/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.core.utils.StringArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class MethodPatternsCellEditor
extends CellEditor {
    private CCombo myControl;
    private StringArrayList myPatterns;

    public MethodPatternsCellEditor(Composite parent) {
        super(parent);
    }

    protected Control createControl(Composite parent) {
        this.myControl = new CCombo(parent, 0);
        this.myControl.setBackground(parent.getBackground());
        this.myControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                MethodPatternsCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.myControl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.myControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                int index = MethodPatternsCellEditor.this.myControl.getSelectionIndex();
                if (index >= 0) {
                    MethodPatternsCellEditor.this.setNewPattern(MethodPatternsCellEditor.this.myControl.getItem(index));
                }
                MethodPatternsCellEditor.super.fireApplyEditorValue();
            }
        });
        return this.myControl;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            this.setNewPattern(this.myControl.getText());
        }
        super.keyReleaseOccured(keyEvent);
    }

    private void setNewPattern(String newPattern) {
        if (this.myPatterns != null && this.myPatterns.size() > 1) {
            this.myPatterns.set(0, (Object)newPattern);
        } else {
            this.myPatterns = new StringArrayList();
            this.myPatterns.add((Object)newPattern);
        }
        this.valueChanged(this.isValueValid(), this.isCorrect(this.myPatterns));
    }

    protected void doSetFocus() {
        this.myControl.setFocus();
    }

    protected Object doGetValue() {
        return this.myPatterns;
    }

    protected void doSetValue(Object value) {
        this.myControl.removeAll();
        this.myControl.setText("");
        this.myPatterns = (StringArrayList)value;
        if (this.myPatterns == null || this.myPatterns.isEmpty()) {
            this.myPatterns = null;
            return;
        }
        this.myPatterns = new StringArrayList(this.myPatterns);
        if (this.myPatterns.size() > 1) {
            int i = 1;
            while (i < this.myPatterns.size()) {
                this.myControl.add(this.myPatterns.getString(i));
                ++i;
            }
        }
        this.myControl.setText(this.myPatterns.getString(0));
    }
}

