/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.utils.StringArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ListEditDialog
extends Dialog {
    private FocusListener myFocusListener = new FocusListener(){

        public void focusGained(FocusEvent event) {
            if (!(event.widget instanceof Text)) {
                return;
            }
            ListEditDialog.this.processItemFocusGained((Text)event.widget);
        }

        public void focusLost(FocusEvent event) {
            if (!(event.widget instanceof Text)) {
                return;
            }
            ListEditDialog.this.processItemFocusLost((Text)event.widget);
        }
    };
    private ModifyListener myModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (!(event.widget instanceof Text)) {
                return;
            }
            ListEditDialog.this.processItemTextModified((Text)event.widget);
        }
    };
    private String myTitle;
    private List myItems;
    private ScrolledComposite myScroller;
    private Composite myItemsPane;
    private Text myItemsAdder;

    public ListEditDialog(Shell shell, List items, String title) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.myItems = this.copyItems(items);
        this.myTitle = title;
    }

    public List getItemsCopy() {
        return new StringArrayList((Collection)this.myItems);
    }

    protected List copyItems(List items) {
        if (items == null || items.isEmpty()) {
            return new StringArrayList();
        }
        StringArrayList itemsCopy = new StringArrayList(items.size());
        int i = 0;
        while (i < items.size()) {
            String itemText;
            Object item = items.get(i);
            if (item instanceof String && ListEditDialog.trim(itemText = (String)item) != null) {
                itemsCopy.add(itemText);
            }
            ++i;
        }
        return itemsCopy;
    }

    protected final List getItems() {
        return this.myItems;
    }

    protected String getItemText(int index) {
        return (String)this.getItems().get(index);
    }

    protected void setItemText(int index, String text) {
        this.getItems().set(index, text);
    }

    protected void addItem(String text) {
        this.getItems().add(text);
    }

    protected final Composite getItemsPane() {
        return this.myItemsPane;
    }

    protected final Text getItemsAdder() {
        return this.myItemsAdder;
    }

    protected final Control createDialogArea(Composite parent) {
        if (this.myTitle != null) {
            this.getShell().setText(this.myTitle);
        }
        Composite mainPlate = (Composite)super.createDialogArea(parent);
        this.decorateMainPlate(mainPlate);
        return mainPlate;
    }

    protected void decorateMainPlate(Composite mainPlate) {
        this.addItemControls(mainPlate);
        this.updateItemsView();
        mainPlate.setSize(100, 200);
    }

    protected void addItemControls(Composite plate) {
        this.myScroller = new ScrolledComposite(plate, 512);
        this.myScroller.setExpandHorizontal(true);
        this.myScroller.setExpandVertical(true);
        this.myScroller.setLayoutData((Object)new GridData(1808));
        this.myItemsPane = new Composite((Composite)this.myScroller, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.myItemsPane.setLayout((Layout)gridLayout);
        this.myScroller.setContent((Control)this.myItemsPane);
        int i = 0;
        while (i < this.myItems.size()) {
            this.addItemControl(this.getItemText(i));
            ++i;
        }
        this.myItemsAdder = this.addItemControl();
    }

    private Text addItemControl() {
        return this.addItemControl("");
    }

    private Text addItemControl(String item) {
        if (this.myItemsPane == null) {
            return null;
        }
        Text itemControl = new Text(this.myItemsPane, 2052);
        itemControl.setLayoutData((Object)new GridData(768));
        itemControl.setText(item);
        itemControl.addModifyListener(this.myModifyListener);
        itemControl.addFocusListener(this.myFocusListener);
        return itemControl;
    }

    protected final int getItemControlIndex(Text itemControl) {
        if (this.myItemsPane == null) {
            return -1;
        }
        return ArrayUtils.indexOf((Object[])this.myItemsPane.getChildren(), (Object)itemControl);
    }

    private void deselectItemControl(int index) {
        Control[] itemControls = this.myItemsPane.getChildren();
        if (itemControls == null || itemControls.length <= 1) {
            this.myItemsAdder.setFocus();
            return;
        }
        if (index < 0 || index >= itemControls.length) {
            this.myItemsAdder.setFocus();
            return;
        }
        Control itemControl = index == itemControls.length - 1 ? itemControls[index - 1] : itemControls[index + 1];
        itemControl.setFocus();
    }

    protected void updateItemsView() {
        if (this.myItemsPane == null || this.myScroller == null) {
            return;
        }
        this.myItemsPane.layout();
        this.myScroller.setMinSize(this.myItemsPane.computeSize(-1, -1));
    }

    protected static String trim(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    protected static int getCharsHeightInPixels(Control control, int chars) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fm = gc.getFontMetrics();
        int height = Dialog.convertHeightInCharsToPixels((FontMetrics)fm, (int)chars);
        gc.dispose();
        return height;
    }

    protected void processItemFocusGained(Text itemControl) {
    }

    protected void processItemFocusLost(Text itemControl) {
        int index;
        String item = itemControl.getText();
        if (ListEditDialog.trim(item) == null && itemControl != this.myItemsAdder && (index = this.getItemControlIndex(itemControl)) >= 0 && index < this.myItems.size()) {
            this.myItems.remove(index);
            itemControl.dispose();
            this.updateItemsView();
        }
    }

    protected void processItemTextModified(Text itemControl) {
        String item = itemControl.getText();
        if (ListEditDialog.trim(item) != null) {
            if (itemControl == this.myItemsAdder) {
                this.addItem(item);
                this.myItemsAdder = this.addItemControl();
                this.updateItemsView();
            } else {
                int index = this.getItemControlIndex(itemControl);
                if (index >= 0 && index < this.myItems.size()) {
                    this.setItemText(index, item);
                }
            }
        }
    }
}

