/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.ui.StringArrayLabelProvider;
import com.tssap.selena.ui.internal.PropertySupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HttpMethodsPropertySupport
extends PropertySupport {
    private static final String HTTP_METHOD_GET = "GET";
    private static final String HTTP_METHOD_PUT = "PUT";
    private static final String HTTP_METHOD_HEAD = "HEAD";
    private static final String HTTP_METHOD_TRACE = "TRACE";
    private static final String HTTP_METHOD_POST = "POST";
    private static final String HTTP_METHOD_DELETE = "DELETE";
    private static final String HTTP_METHOD_OPTIONS = "OPTIONS";
    private static final String[] HTTP_METHODS = new String[]{"GET", "PUT", "HEAD", "TRACE", "POST", "DELETE", "OPTIONS"};
    private static final String TITLE = "HTTP Methods";

    protected ILabelProvider createLabelProvider() {
        return new StringArrayLabelProvider();
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new HttpMethodsCellEditor(parent);
    }

    private static class HttpMethodsDialog
    extends Dialog {
        private StringArrayList myHttpMethods = new StringArrayList();

        public HttpMethodsDialog(Shell shell, String[] httpMethods) {
            super(shell);
            if (httpMethods != null && httpMethods.length > 0) {
                int i = 0;
                while (i < httpMethods.length) {
                    String httpMethod = httpMethods[i];
                    if (httpMethod != null && (httpMethod = httpMethod.trim()).length() != 0) {
                        this.myHttpMethods.add((Object)httpMethod);
                    }
                    ++i;
                }
            }
        }

        public String[] getHttpMethods() {
            return this.myHttpMethods.toArray(new String[this.myHttpMethods.size()]);
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(HttpMethodsPropertySupport.TITLE);
            Composite composite = (Composite)super.createDialogArea(parent);
            int i = 0;
            while (i < HTTP_METHODS.length) {
                String httpMethod = HTTP_METHODS[i];
                Composite plate = new Composite(composite, 0);
                GridData plateGridData = new GridData(1040);
                plate.setLayoutData((Object)plateGridData);
                GridLayout plateLayout = new GridLayout();
                plateLayout.marginHeight = 0;
                plateLayout.marginWidth = 0;
                plateLayout.numColumns = 2;
                plate.setLayout((Layout)plateLayout);
                Button check = new Button(plate, 32);
                check.addSelectionListener(new SelectionListener(this, check, httpMethod){
                    private final /* synthetic */ Button val$check;
                    private final /* synthetic */ String val$httpMethod;
                    private final /* synthetic */ HttpMethodsDialog this$0;
                    {
                        this.this$0 = this$0;
                        this.val$check = val$check;
                        this.val$httpMethod = val$httpMethod;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        if (this.val$check.getSelection()) {
                            HttpMethodsDialog.access$100(this.this$0).add((Object)this.val$httpMethod);
                        } else {
                            HttpMethodsDialog.access$100(this.this$0).remove(this.val$httpMethod);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (this.myHttpMethods.contains(httpMethod)) {
                    check.setSelection(true);
                }
                Label label = new Label(plate, 0);
                label.setText(httpMethod);
                ++i;
            }
            return composite;
        }

        protected static int getCharsHeightInPixels(Control control, int chars) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            FontMetrics fm = gc.getFontMetrics();
            int height = Dialog.convertHeightInCharsToPixels((FontMetrics)fm, (int)chars);
            gc.dispose();
            return height;
        }

        static /* synthetic */ StringArrayList access$100(HttpMethodsDialog x0) {
            return x0.myHttpMethods;
        }
    }

    private static class HttpMethodsCellEditor
    extends DialogCellEditor {
        public HttpMethodsCellEditor(Composite parent) {
            super(parent);
        }

        public final String[] getStringArrayValue() {
            Object value = this.getValue();
            if (value instanceof String[]) {
                return (String[])value;
            }
            return null;
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            String[] sValue = this.getStringArrayValue();
            HttpMethodsDialog dialog = new HttpMethodsDialog(cellEditorWindow.getShell(), sValue);
            if (dialog.open() == 0) {
                sValue = dialog.getHttpMethods();
            }
            return sValue;
        }

        protected void updateContents(Object value) {
            this.getDefaultLabel().setText(StringArrayLabelProvider.toString(value));
        }
    }
}

