/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.ui.property.element.GenericElementProperty;

public class GenericStringArrayListElementProperty
extends GenericElementProperty {
    private static final String UNABLE_ERR_MSG = "Unable to set value";
    private static final String INVALID_VALUE_TYPE_ERR_MSG = "Invalid value type";
    private static final String INVALID_VALUE_ERR_MSG = "Invalid value";

    public Object getValue() {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        String propertyName = this.getModelPropertyName();
        if (propertyName == null) {
            return null;
        }
        return this.getStringArrayList(element.getObjectPropertyValue(propertyName));
    }

    public void setValue(Object value) {
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        String propertyName = this.getModelPropertyName();
        if (propertyName == null) {
            return;
        }
        element.setObjectPropertyValue(propertyName, (Object)this.getStringArrayList(value));
    }

    public String isValidValue(Object value) {
        Element element = this.getElement();
        if (element == null) {
            return UNABLE_ERR_MSG;
        }
        String propertyName = this.getModelPropertyName();
        if (propertyName == null) {
            return UNABLE_ERR_MSG;
        }
        if (value != null && !(value instanceof StringArrayList)) {
            return INVALID_VALUE_TYPE_ERR_MSG;
        }
        if (!element.canSetObjectPropertyValue(propertyName, (Object)this.getStringArrayList(value))) {
            return INVALID_VALUE_ERR_MSG;
        }
        return null;
    }

    protected StringArrayList getStringArrayList(Object value) {
        if (value instanceof StringArrayList) {
            StringArrayList salValue = (StringArrayList)value;
            return salValue.isEmpty() ? null : salValue;
        }
        return null;
    }

    protected Element getElement() {
        Object object = this.getObject();
        if (object instanceof Element) {
            return (Element)object;
        }
        return null;
    }
}

