/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ejbjar.dd.IAssemblyDescriptor;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.IEjbLocalRef;
import com.tssap.j2ee.model.ejbjar.dd.IEjbRef;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBean;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBeans;
import com.tssap.j2ee.model.ejbjar.dd.IEntity;
import com.tssap.j2ee.model.ejbjar.dd.IMessageDriven;
import com.tssap.j2ee.model.ejbjar.dd.IMethodPermission;
import com.tssap.j2ee.model.ejbjar.dd.IResourceEnvRef;
import com.tssap.j2ee.model.ejbjar.dd.IResourceRef;
import com.tssap.j2ee.model.ejbjar.dd.IRoleName;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityIdentity;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityRole;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityRoleRef;
import com.tssap.j2ee.model.ejbjar.dd.ISession;
import com.tssap.j2ee.model.web.dd.IAuthConstraint;
import com.tssap.j2ee.model.web.dd.ISecurityConstraint;
import com.tssap.j2ee.model.web.dd.IServlet;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;

public class GenericReferencesCheck {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$GenericReferencesCheck == null ? (class$com$tssap$j2ee$ui$GenericReferencesCheck = GenericReferencesCheck.class$("com.tssap.j2ee.ui.GenericReferencesCheck")) : class$com$tssap$j2ee$ui$GenericReferencesCheck));
    IWebApp webApp = null;
    IEjbJar ejbJar = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$GenericReferencesCheck;

    public GenericReferencesCheck(IIdentifiable iidentifiable, Object deletedObject) {
        this.deleteReferences(iidentifiable, deletedObject);
    }

    public GenericReferencesCheck(IIdentifiable iidentifiable, String oldString, Object updatedObject) {
        this.updateReferences(iidentifiable, oldString, updatedObject);
    }

    private void deleteReferences(IIdentifiable iidentifiable, Object deletedObject) {
        IReferenceDeleter referenceDeleter = null;
        if (iidentifiable instanceof IEjbJar) {
            if (deletedObject instanceof ISecurityRole) {
                referenceDeleter = new SecurityRoleRefDeleterImpl((IEjbJar)iidentifiable, (ISecurityRole)deletedObject);
            }
        } else if (iidentifiable instanceof IWebApp && deletedObject instanceof com.tssap.j2ee.model.web.dd.ISecurityRole) {
            referenceDeleter = new SecurityRoleRefDeleterImpl((IWebApp)iidentifiable, (com.tssap.j2ee.model.web.dd.ISecurityRole)deletedObject);
        }
        if (referenceDeleter != null) {
            referenceDeleter.deleteReferences();
        }
    }

    private void updateReferences(IIdentifiable iidentifiable, String oldString, Object updatedObject) {
        IReferenceUpdater referenceUpdater = null;
        if (iidentifiable instanceof IEjbJar) {
            if (updatedObject instanceof ISecurityRole) {
                referenceUpdater = new SecurityRoleRefUpdaterImpl((IEjbJar)iidentifiable, (ISecurityRole)updatedObject, oldString);
            }
        } else if (iidentifiable instanceof IWebApp && updatedObject instanceof com.tssap.j2ee.model.web.dd.ISecurityRole) {
            referenceUpdater = new SecurityRoleRefUpdaterImpl((IWebApp)iidentifiable, (com.tssap.j2ee.model.web.dd.ISecurityRole)updatedObject, oldString);
        }
        if (referenceUpdater != null) {
            referenceUpdater.updateReferences(oldString);
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(this.getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SecurityRoleRefUpdaterImpl
    extends ReferenceUpdaterImpl
    implements IReferenceUpdater {
        String oldString = null;

        public SecurityRoleRefUpdaterImpl(IEjbJar ejbJar, ISecurityRole updatedObject, String oldString) {
            this.setModel((IIdentifiable)ejbJar);
            this.setUpdatedObject((IIdentifiable)updatedObject);
            this.oldString = oldString;
        }

        public SecurityRoleRefUpdaterImpl(IWebApp webApp, com.tssap.j2ee.model.web.dd.ISecurityRole updatedObject, String oldString) {
            this.setModel((IIdentifiable)webApp);
            this.setUpdatedObject((IIdentifiable)updatedObject);
            this.oldString = oldString;
        }

        public void updateReferences(String oldValue) {
            if (this.getModel() != null && this.getUpdatedObject() != null) {
                IIdentifiable updatedObject = this.getUpdatedObject();
                if (this.getModel() instanceof IWebApp) {
                    IWebApp webApp = (IWebApp)this.getModel();
                    if (updatedObject instanceof com.tssap.j2ee.model.web.dd.ISecurityRole) {
                        this.updateSecurityRoleReferences(webApp, (com.tssap.j2ee.model.web.dd.ISecurityRole)updatedObject, oldValue);
                    }
                } else if (this.getModel() instanceof IEjbJar) {
                    IEjbJar ejbJar = (IEjbJar)this.getModel();
                    if (updatedObject instanceof ISecurityRole) {
                        this.updateSecurityRoleReferences(ejbJar, (ISecurityRole)updatedObject, oldValue);
                    }
                }
            }
        }

        private boolean updateSecurityRoleReferences(IWebApp webApp, com.tssap.j2ee.model.web.dd.ISecurityRole updatedObject, String oldRoleName) {
            boolean referencesAreUpdated = false;
            if (webApp != null) {
                IServlet[] servlets = webApp.getServlets();
                if (servlets != null && servlets.length > 0) {
                    int i = 0;
                    while (i < servlets.length) {
                        com.tssap.j2ee.model.web.dd.ISecurityRoleRef[] securityRoleRefs = servlets[i].getSecurityRoleRefs();
                        int k = 0;
                        while (k < securityRoleRefs.length) {
                            if (securityRoleRefs[k].getRoleLink() != null && securityRoleRefs[k].getRoleLink().getValue().equals(oldRoleName)) {
                                securityRoleRefs[k].getRoleLink().setValue(updatedObject.getRoleName().getValue());
                                referencesAreUpdated = true;
                            } else if (securityRoleRefs[k].getRoleName() != null && securityRoleRefs[k].getRoleName().getValue().equals(oldRoleName)) {
                                securityRoleRefs[k].getRoleName().setValue(updatedObject.getRoleName().getValue());
                                referencesAreUpdated = true;
                            }
                            ++k;
                        }
                        if (servlets[i].getRunAs() != null && servlets[i].getRunAs().getRoleName().getValue().equals(oldRoleName)) {
                            servlets[i].getRunAs().getRoleName().setValue(updatedObject.getRoleName().getValue());
                            referencesAreUpdated = true;
                        }
                        referencesAreUpdated = true;
                        ++i;
                    }
                }
                ISecurityConstraint[] securityConstraintArr = webApp.getSecurityConstraints();
                int i = 0;
                while (i < securityConstraintArr.length) {
                    IAuthConstraint authConstraint = securityConstraintArr[i].getAuthConstraint();
                    if (authConstraint != null) {
                        com.tssap.j2ee.model.web.dd.IRoleName[] roleNames = authConstraint.getRoleNames();
                        int j = 0;
                        while (j < roleNames.length) {
                            if (roleNames[j].getValue().equals(oldRoleName)) {
                                roleNames[j].setValue(updatedObject.getRoleName().getValue());
                                referencesAreUpdated = true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            return referencesAreUpdated;
        }

        private boolean updateSecurityRoleReferences(IEjbJar ejbJar, ISecurityRole updatedObject, String oldRoleName) {
            boolean referencesAreUpdated = false;
            ISecurityIdentity securityIdentity = null;
            ISecurityRoleRef[] securityRoleRefs = null;
            if (ejbJar != null) {
                IAssemblyDescriptor assemblyDescriptor;
                IEnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
                if (enterpriseBeans != null) {
                    ISession[] sessionBeans = enterpriseBeans.getSessions();
                    IEntity[] entityBeans = enterpriseBeans.getEntitys();
                    IMessageDriven[] messageDrivenBeans = enterpriseBeans.getMessageDrivens();
                    if (sessionBeans != null && sessionBeans.length > 0) {
                        int i = 0;
                        while (i < sessionBeans.length) {
                            securityIdentity = sessionBeans[i].getSecurityIdentity();
                            this.checkSecurityIdentityForSecurityReferenceUpdate(securityIdentity, (IEnterpriseBean)sessionBeans[i], updatedObject, oldRoleName);
                            securityRoleRefs = sessionBeans[i].getSecurityRoleRefs();
                            this.checkSecurityRoleRefsForReferenceUpdate(securityRoleRefs, (IEnterpriseBean)sessionBeans[i], updatedObject, oldRoleName);
                            ++i;
                        }
                    }
                    if (entityBeans != null && entityBeans.length > 0) {
                        int k = 0;
                        while (k < entityBeans.length) {
                            securityIdentity = entityBeans[k].getSecurityIdentity();
                            this.checkSecurityIdentityForSecurityReferenceUpdate(securityIdentity, (IEnterpriseBean)entityBeans[k], updatedObject, oldRoleName);
                            securityRoleRefs = entityBeans[k].getSecurityRoleRefs();
                            this.checkSecurityRoleRefsForReferenceUpdate(securityRoleRefs, (IEnterpriseBean)entityBeans[k], updatedObject, oldRoleName);
                            ++k;
                        }
                    }
                    if (messageDrivenBeans != null && messageDrivenBeans.length > 0) {
                        int n = 0;
                        while (n < messageDrivenBeans.length) {
                            securityIdentity = messageDrivenBeans[n].getSecurityIdentity();
                            this.checkSecurityIdentityForSecurityReferenceUpdate(securityIdentity, (IEnterpriseBean)messageDrivenBeans[n], updatedObject, oldRoleName);
                            ++n;
                        }
                    }
                }
                if ((assemblyDescriptor = ejbJar.getAssemblyDescriptor()) != null) {
                    IMethodPermission[] methodPermissions = assemblyDescriptor.getMethodPermissions();
                    IRoleName[] roleNames = null;
                    int j = 0;
                    while (j < methodPermissions.length) {
                        roleNames = methodPermissions[j].getRoleNames();
                        int m = 0;
                        while (m < roleNames.length) {
                            if (roleNames[m].getValue().equals(oldRoleName)) {
                                roleNames[m].setValue(updatedObject.getRoleName().getValue());
                                referencesAreUpdated = true;
                            }
                            ++m;
                        }
                        ++j;
                    }
                }
            }
            return referencesAreUpdated;
        }

        private boolean checkSecurityIdentityForSecurityReferenceUpdate(ISecurityIdentity securityIdentity, IEnterpriseBean enterpriseBean, ISecurityRole updatedObject, String oldName) {
            boolean referencesAreUpdated = false;
            if (securityIdentity != null && securityIdentity.getRunAs() != null && securityIdentity.getRunAs().getRoleName().getValue().equals(oldName)) {
                securityIdentity.getRunAs().getRoleName().setValue(updatedObject.getRoleName().getValue());
            }
            return referencesAreUpdated;
        }

        private boolean checkSecurityRoleRefsForReferenceUpdate(ISecurityRoleRef[] securityRoleRefs, IEnterpriseBean enterpriseBean, ISecurityRole updatedObject, String oldName) {
            boolean referencesAreUpdated = false;
            int h = 0;
            while (h < securityRoleRefs.length) {
                if (securityRoleRefs[h].getRoleLink() != null && securityRoleRefs[h].getRoleLink().getValue().equals(oldName)) {
                    securityRoleRefs[h].getRoleLink().setValue(updatedObject.getRoleName().getValue());
                } else if (securityRoleRefs[h].getRoleName() != null && securityRoleRefs[h].getRoleName().getValue().equals(oldName)) {
                    securityRoleRefs[h].getRoleName().setValue(updatedObject.getRoleName().getValue());
                }
                ++h;
            }
            return referencesAreUpdated;
        }
    }

    private class ResourceEnvRefDeleterImpl
    extends ReferenceDeleterImpl
    implements IReferenceDeleter {
        private ResourceEnvRefDeleterImpl() {
        }

        private IResourceEnvRef[] getResourceEnvRefs() {
            return null;
        }

        public void deleteReferences() {
        }
    }

    private class ResourceRefDeleterImpl
    extends ReferenceDeleterImpl
    implements IReferenceDeleter {
        private ResourceRefDeleterImpl() {
        }

        private IResourceRef[] getResourceRefs() {
            return null;
        }

        public void deleteReferences() {
        }
    }

    private class EjbLocalRefDeleterImpl
    extends ReferenceDeleterImpl
    implements IReferenceDeleter {
        private EjbLocalRefDeleterImpl() {
        }

        private IEjbLocalRef[] getEjbLocalRefs() {
            return null;
        }

        public void deleteReferences() {
        }
    }

    private class EjbRefDeleterImpl
    extends ReferenceDeleterImpl
    implements IReferenceDeleter {
        private EjbRefDeleterImpl() {
        }

        private IEjbRef[] getEjbRefs() {
            return null;
        }

        public void deleteReferences() {
        }
    }

    private class SecurityRoleRefDeleterImpl
    extends ReferenceDeleterImpl
    implements IReferenceDeleter {
        public SecurityRoleRefDeleterImpl(IEjbJar ejbJar, ISecurityRole deletedObject) {
            this.setModel((IIdentifiable)ejbJar);
            this.setDeletedObject((IIdentifiable)deletedObject);
        }

        public SecurityRoleRefDeleterImpl(IWebApp webApp, com.tssap.j2ee.model.web.dd.ISecurityRole deletedObject) {
            this.setModel((IIdentifiable)webApp);
            this.setDeletedObject((IIdentifiable)deletedObject);
        }

        public void deleteReferences() {
            if (this.getModel() != null && this.getDeletedObject() != null) {
                IIdentifiable deletedObject = this.getDeletedObject();
                if (this.getModel() instanceof IWebApp) {
                    IWebApp webApp = (IWebApp)this.getModel();
                    if (deletedObject instanceof com.tssap.j2ee.model.web.dd.ISecurityRole) {
                        this.removeSecurityRoleReferences(webApp, (com.tssap.j2ee.model.web.dd.ISecurityRole)deletedObject);
                    }
                } else if (this.getModel() instanceof IEjbJar) {
                    IEjbJar ejbJar = (IEjbJar)this.getModel();
                    if (deletedObject instanceof ISecurityRole) {
                        this.removeSecurityRoleReferences(ejbJar, (ISecurityRole)deletedObject);
                    }
                }
            }
        }

        private boolean removeSecurityRoleReferences(IWebApp webApp, com.tssap.j2ee.model.web.dd.ISecurityRole deletedObject) {
            boolean referencesAreDeleted = false;
            if (webApp != null) {
                IServlet[] servlets = webApp.getServlets();
                if (servlets != null && servlets.length > 0) {
                    int i = 0;
                    while (i < servlets.length) {
                        com.tssap.j2ee.model.web.dd.ISecurityRoleRef[] securityRoleRefs = servlets[i].getSecurityRoleRefs();
                        int k = 0;
                        while (k < securityRoleRefs.length) {
                            if (securityRoleRefs[k].getRoleLink() != null && deletedObject.getRoleName().getValue().equals(securityRoleRefs[k].getRoleLink().getValue())) {
                                servlets[i].removeSecurityRoleRef(securityRoleRefs[k]);
                                referencesAreDeleted = true;
                            } else if (securityRoleRefs[k].getRoleName() != null && deletedObject.getRoleName().getValue().equals(securityRoleRefs[k].getRoleName().getValue())) {
                                servlets[i].removeSecurityRoleRef(securityRoleRefs[k]);
                                referencesAreDeleted = true;
                            }
                            ++k;
                        }
                        if (servlets[i].getRunAs() != null && servlets[i].getRunAs().getRoleName().getValue().equals(deletedObject.getRoleName().getValue())) {
                            servlets[i].removeRunAs();
                            referencesAreDeleted = true;
                        }
                        referencesAreDeleted = true;
                        ++i;
                    }
                }
                ISecurityConstraint[] securityConstraintArr = webApp.getSecurityConstraints();
                int i = 0;
                while (i < securityConstraintArr.length) {
                    IAuthConstraint authConstraint = securityConstraintArr[i].getAuthConstraint();
                    if (authConstraint != null) {
                        com.tssap.j2ee.model.web.dd.IRoleName[] roleNames = authConstraint.getRoleNames();
                        int j = 0;
                        while (j < roleNames.length) {
                            if (deletedObject.getRoleName().getValue().equals(roleNames[j].getValue())) {
                                authConstraint.removeRoleName(roleNames[j]);
                                referencesAreDeleted = true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            return referencesAreDeleted;
        }

        private boolean removeSecurityRoleReferences(IEjbJar ejbJar, ISecurityRole deletedObject) {
            boolean referencesAreDeleted = false;
            ISecurityIdentity securityIdentity = null;
            ISecurityRoleRef[] securityRoleRefs = null;
            if (ejbJar != null) {
                IAssemblyDescriptor assemblyDescriptor;
                IEnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
                if (enterpriseBeans != null) {
                    ISession[] sessionBeans = enterpriseBeans.getSessions();
                    IEntity[] entityBeans = enterpriseBeans.getEntitys();
                    IMessageDriven[] messageDrivenBeans = enterpriseBeans.getMessageDrivens();
                    if (sessionBeans != null && sessionBeans.length > 0) {
                        int i = 0;
                        while (i < sessionBeans.length) {
                            securityIdentity = sessionBeans[i].getSecurityIdentity();
                            this.checkSecurityIdentityForSecurityReferenceRemoval(securityIdentity, (IEnterpriseBean)sessionBeans[i], deletedObject);
                            securityRoleRefs = sessionBeans[i].getSecurityRoleRefs();
                            this.checkSecurityRoleRefsForReferenceRemoval(securityRoleRefs, (IEnterpriseBean)sessionBeans[i], deletedObject);
                            ++i;
                        }
                    }
                    if (entityBeans != null && entityBeans.length > 0) {
                        int k = 0;
                        while (k < entityBeans.length) {
                            securityIdentity = entityBeans[k].getSecurityIdentity();
                            this.checkSecurityIdentityForSecurityReferenceRemoval(securityIdentity, (IEnterpriseBean)entityBeans[k], deletedObject);
                            securityRoleRefs = entityBeans[k].getSecurityRoleRefs();
                            this.checkSecurityRoleRefsForReferenceRemoval(securityRoleRefs, (IEnterpriseBean)entityBeans[k], deletedObject);
                            ++k;
                        }
                    }
                    if (messageDrivenBeans != null && messageDrivenBeans.length > 0) {
                        int n = 0;
                        while (n < messageDrivenBeans.length) {
                            securityIdentity = messageDrivenBeans[n].getSecurityIdentity();
                            this.checkSecurityIdentityForSecurityReferenceRemoval(securityIdentity, (IEnterpriseBean)messageDrivenBeans[n], deletedObject);
                            ++n;
                        }
                    }
                }
                if ((assemblyDescriptor = ejbJar.getAssemblyDescriptor()) != null) {
                    IMethodPermission[] methodPermissions = assemblyDescriptor.getMethodPermissions();
                    IRoleName[] roleNames = null;
                    int j = 0;
                    while (j < methodPermissions.length) {
                        roleNames = methodPermissions[j].getRoleNames();
                        int m = 0;
                        while (m < roleNames.length) {
                            if (deletedObject.getRoleName().getValue().equals(roleNames[m].getValue())) {
                                methodPermissions[j].removeRoleName(roleNames[m]);
                                referencesAreDeleted = true;
                            }
                            ++m;
                        }
                        ++j;
                    }
                }
            }
            return referencesAreDeleted;
        }

        private boolean checkSecurityIdentityForSecurityReferenceRemoval(ISecurityIdentity securityIdentity, IEnterpriseBean enterpriseBean, ISecurityRole deletedObject) {
            boolean referencesAreDeleted = false;
            if (securityIdentity != null && securityIdentity.getRunAs() != null && securityIdentity.getRunAs().getRoleName().getValue().equals(deletedObject.getRoleName().getValue())) {
                securityIdentity.removeRunAs();
                try {
                    securityIdentity.createUseCallerIdentity(null);
                }
                catch (J2eeCreateException e) {
                    GenericReferencesCheck.this.handleJ2eeCreateException("<use-caller-identity> could not be created.", e);
                }
            }
            return referencesAreDeleted;
        }

        private boolean checkSecurityRoleRefsForReferenceRemoval(ISecurityRoleRef[] securityRoleRefs, IEnterpriseBean enterpriseBean, ISecurityRole deletedObject) {
            boolean referencesAreDeleted = false;
            int h = 0;
            while (h < securityRoleRefs.length) {
                if (securityRoleRefs[h].getRoleLink() != null && (securityRoleRefs[h].getRoleLink().getValue().equals(deletedObject.getRoleName().getValue()) || securityRoleRefs[h].getRoleName().getValue().equals(deletedObject.getRoleName().getValue()))) {
                    if (enterpriseBean instanceof ISession) {
                        ((ISession)enterpriseBean).removeSecurityRoleRef(securityRoleRefs[h]);
                    } else if (enterpriseBean instanceof IEntity) {
                        ((IEntity)enterpriseBean).removeSecurityRoleRef(securityRoleRefs[h]);
                    }
                }
                ++h;
            }
            return referencesAreDeleted;
        }
    }

    private abstract class ReferenceUpdaterImpl
    implements IReferenceUpdater {
        IIdentifiable model = null;
        IIdentifiable updatedObject = null;

        private ReferenceUpdaterImpl() {
        }

        public IIdentifiable getModel() {
            return this.model;
        }

        public IIdentifiable getUpdatedObject() {
            return this.updatedObject;
        }

        public void setModel(IIdentifiable iidentifiable) {
            this.model = iidentifiable;
        }

        public void setUpdatedObject(IIdentifiable iidentifiable) {
            this.updatedObject = iidentifiable;
        }

        public abstract void updateReferences(String var1);
    }

    private abstract class ReferenceDeleterImpl
    implements IReferenceDeleter {
        IIdentifiable model = null;
        IIdentifiable deletedObject = null;

        private ReferenceDeleterImpl() {
        }

        public IIdentifiable getDeletedObject() {
            return this.deletedObject;
        }

        public IIdentifiable getModel() {
            return this.model;
        }

        public void setDeletedObject(IIdentifiable iidentifiable) {
            this.deletedObject = iidentifiable;
        }

        public void setModel(IIdentifiable iidentifiable) {
            this.model = iidentifiable;
        }

        public abstract void deleteReferences();
    }

    private static interface IReferenceUpdater
    extends IReferenceHandler {
        public IIdentifiable getUpdatedObject();

        public void setUpdatedObject(IIdentifiable var1);

        public void updateReferences(String var1);
    }

    private static interface IReferenceDeleter
    extends IReferenceHandler {
        public IIdentifiable getDeletedObject();

        public void setDeletedObject(IIdentifiable var1);

        public void deleteReferences();
    }

    private static interface IReferenceHandler {
        public IIdentifiable getModel();

        public void setModel(IIdentifiable var1);
    }
}

