/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.selena.ui.internal.PropertySupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DescribedStringPropertySupport
extends PropertySupport {
    private static final String DEFAULT_NAME = "Name";
    private static final String DEFAULT_DESCRIPTION = "Description";
    public static final String TITLE_ATTRIBUTE = "title";
    public static final String NAME_ATTRIBUTE = "nameLabel";
    public static final String DESCRIPTION_ATTRIBUTE = "descriptionLabel";
    private String myTitle;
    private String myName;
    private String myDescription;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        this.myTitle = config.getAttribute(TITLE_ATTRIBUTE);
        this.myName = config.getAttribute(NAME_ATTRIBUTE);
        this.myDescription = config.getAttribute(DESCRIPTION_ATTRIBUTE);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new DescribedStringCellEditor(parent, this.myTitle, this.myName, this.myDescription);
    }

    protected ILabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    protected static String getName(StringArrayList value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value.getString(0);
    }

    protected static String getDescription(StringArrayList value) {
        if (value == null || value.size() < 2) {
            return null;
        }
        return value.getString(1);
    }

    private static class DescribedStringDialog
    extends Dialog {
        private String myName;
        private String myDescription;
        private String myTitle;
        private String myNameLabel;
        private String myDescriptionLabel;

        public DescribedStringDialog(Shell shell, String name, String description, String title, String nameLabel, String descriptionLabel) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.myName = name == null ? "" : name;
            this.myDescription = description == null ? "" : description;
            this.myTitle = title;
            this.myNameLabel = nameLabel;
            this.myDescriptionLabel = descriptionLabel;
        }

        public String getName() {
            return DescribedStringDialog.trim(this.myName);
        }

        public String getDescription() {
            return DescribedStringDialog.trim(this.myDescription);
        }

        protected Control createDialogArea(Composite parent) {
            if (this.myTitle != null) {
                this.getShell().setText(this.myTitle);
            }
            Composite composite = (Composite)super.createDialogArea(parent);
            Label nameLabel = new Label(composite, 256);
            nameLabel.setText(this.myNameLabel == null ? DescribedStringPropertySupport.DEFAULT_NAME : this.myNameLabel);
            Text nameText = new Text(composite, 2052);
            nameText.setText(this.myName);
            nameText.addModifyListener(new ModifyListener(this, nameText){
                private final /* synthetic */ Text val$nameText;
                private final /* synthetic */ DescribedStringDialog this$0;
                {
                    this.this$0 = this$0;
                    this.val$nameText = val$nameText;
                }

                public void modifyText(ModifyEvent event) {
                    DescribedStringDialog.access$002(this.this$0, this.val$nameText.getText());
                }
            });
            nameText.setLayoutData((Object)new GridData(768));
            Label descriptionLabel = new Label(composite, 256);
            descriptionLabel.setText(this.myDescriptionLabel == null ? DescribedStringPropertySupport.DEFAULT_DESCRIPTION : this.myDescriptionLabel);
            Text descriptionText = new Text(composite, 2626);
            descriptionText.setText(this.myDescription);
            descriptionText.addModifyListener(new ModifyListener(this, descriptionText){
                private final /* synthetic */ Text val$descriptionText;
                private final /* synthetic */ DescribedStringDialog this$0;
                {
                    this.this$0 = this$0;
                    this.val$descriptionText = val$descriptionText;
                }

                public void modifyText(ModifyEvent event) {
                    DescribedStringDialog.access$102(this.this$0, this.val$descriptionText.getText());
                }
            });
            GridData descriptionData = new GridData(1808);
            descriptionData.heightHint = DescribedStringDialog.getCharsHeightInPixels((Control)descriptionText, 3);
            descriptionText.setLayoutData((Object)descriptionData);
            return composite;
        }

        private static String trim(String s) {
            if (s == null) {
                return null;
            }
            if ((s = s.trim()).length() == 0) {
                return null;
            }
            return s;
        }

        private static int getCharsHeightInPixels(Control control, int chars) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            FontMetrics fm = gc.getFontMetrics();
            int height = Dialog.convertHeightInCharsToPixels((FontMetrics)fm, (int)chars);
            gc.dispose();
            return height;
        }

        static /* synthetic */ String access$002(DescribedStringDialog x0, String x1) {
            x0.myName = x1;
            return x0.myName;
        }

        static /* synthetic */ String access$102(DescribedStringDialog x0, String x1) {
            x0.myDescription = x1;
            return x0.myDescription;
        }
    }

    private static class DescribedStringCellEditor
    extends DialogCellEditor {
        private String myTitle;
        private String myName;
        private String myDescription;

        public DescribedStringCellEditor(Composite parent, String title, String name, String description) {
            super(parent);
            this.myTitle = title;
            this.myName = name;
            this.myDescription = description;
        }

        public final StringArrayList getStringArrayListValue() {
            Object value = this.getValue();
            if (value instanceof StringArrayList) {
                return (StringArrayList)value;
            }
            return null;
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            StringArrayList salValue = this.getStringArrayListValue();
            DescribedStringDialog dialog = new DescribedStringDialog(cellEditorWindow.getShell(), DescribedStringPropertySupport.getName(salValue), DescribedStringPropertySupport.getDescription(salValue), this.myTitle, this.myName, this.myDescription);
            if (dialog.open() == 0) {
                String name = dialog.getName();
                if (name == null || name.trim().length() == 0) {
                    salValue = StringArrayList.EMPTY_LIST;
                } else {
                    salValue = new StringArrayList(2);
                    salValue.add((Object)name);
                    String description = dialog.getDescription();
                    if (description != null) {
                        salValue.add((Object)description);
                    }
                }
            }
            return salValue;
        }
    }
}

