/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.ui.ListEditDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DescribedListEditDialog
extends ListEditDialog {
    private Text mySelectedItem;
    private Text myDescription;

    public DescribedListEditDialog(Shell shell, List items, String title) {
        super(shell, items, title);
    }

    public List getItemsCopy() {
        List items = this.getItems();
        ArrayList<StringArrayList> itemsCopy = new ArrayList<StringArrayList>(items.size());
        int i = 0;
        while (i < items.size()) {
            itemsCopy.add(new StringArrayList((StringArrayList)items.get(i)));
            ++i;
        }
        return itemsCopy;
    }

    protected List copyItems(List items) {
        if (items == null || items.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<StringArrayList> itemsCopy = new ArrayList<StringArrayList>(items.size());
        int i = 0;
        while (i < items.size()) {
            StringArrayList item;
            Object itemObj = items.get(i);
            if (itemObj instanceof StringArrayList && !(item = (StringArrayList)itemObj).isEmpty() && ListEditDialog.trim(item.getString(0)) != null) {
                itemsCopy.add(new StringArrayList(item));
            }
            ++i;
        }
        return itemsCopy;
    }

    protected StringArrayList getItem(int i) {
        return (StringArrayList)this.getItems().get(i);
    }

    protected String getItemText(int i) {
        return this.getItem(i).getString(0);
    }

    protected void setItemText(int index, String text) {
        this.getItem(index).set(0, (Object)text);
    }

    protected String getItemDescription(int i) {
        StringArrayList item = this.getItem(i);
        if (item.size() < 2) {
            return "";
        }
        return item.getString(1);
    }

    protected void setItemDescription(int i, String description) {
        StringArrayList item = this.getItem(i);
        if (item.size() < 2) {
            item.add((Object)description);
        } else {
            item.set(1, (Object)description);
        }
    }

    protected void addItem(String text) {
        StringArrayList itemCage = new StringArrayList(2);
        itemCage.add((Object)text);
        String description = this.myDescription.getText();
        if (ListEditDialog.trim(description) != null) {
            itemCage.add((Object)description);
        }
        this.getItems().add(itemCage);
    }

    protected Text getSelectedItemControl() {
        return this.mySelectedItem;
    }

    protected void decorateMainPlate(Composite mainPlate) {
        SashForm sashPlate = this.createSash(mainPlate);
        this.addItemControls((Composite)sashPlate);
        this.addDescriptionControl((Composite)sashPlate);
        sashPlate.setWeights(new int[]{2, 1});
        this.updateItemsView();
        mainPlate.setSize(100, 200);
    }

    protected SashForm createSash(Composite plate) {
        SashForm sashPlate = new SashForm(plate, 512);
        sashPlate.setLayoutData((Object)new GridData(1808));
        GridLayout sashLayout = new GridLayout();
        sashLayout.marginWidth = 0;
        sashLayout.marginHeight = 0;
        sashLayout.horizontalSpacing = 0;
        sashLayout.verticalSpacing = 0;
        sashPlate.setLayout((Layout)sashLayout);
        return sashPlate;
    }

    protected void addItemControls(Composite plate) {
        super.addItemControls(plate);
        this.mySelectedItem = (Text)this.getItemsPane().getChildren()[0];
    }

    protected void addDescriptionControl(Composite plate) {
        Composite intPlate = new Composite(plate, 0);
        intPlate.setLayoutData((Object)new GridData(1808));
        GridLayout intLayout = new GridLayout();
        intLayout.marginWidth = 0;
        intLayout.marginHeight = 0;
        intLayout.horizontalSpacing = 0;
        intLayout.verticalSpacing = 0;
        intPlate.setLayout((Layout)intLayout);
        Label label = new Label(intPlate, 0);
        label.setText("Description");
        GridData labelData = new GridData();
        labelData.heightHint = ListEditDialog.getCharsHeightInPixels((Control)label, 1) + 2;
        label.setLayoutData((Object)labelData);
        this.myDescription = new Text(intPlate, 2626);
        GridData gridData = new GridData(1808);
        gridData.heightHint = ListEditDialog.getCharsHeightInPixels((Control)this.myDescription, 4);
        this.myDescription.setLayoutData((Object)gridData);
        if (!this.getItems().isEmpty()) {
            this.myDescription.setText(this.getItemDescription(0));
        }
        this.myDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DescribedListEditDialog.this.processDescriptionModified();
            }
        });
    }

    protected void processItemFocusGained(Text itemControl) {
        super.processItemFocusGained(itemControl);
        this.mySelectedItem = itemControl;
        int index = this.getItemControlIndex(this.mySelectedItem);
        if (index >= 0 && index < this.getItems().size()) {
            this.myDescription.setText(this.getItemDescription(index));
        } else {
            this.myDescription.setText("");
        }
    }

    protected void processDescriptionModified() {
        int index = this.getItemControlIndex(this.mySelectedItem);
        if (index >= 0 && index < this.getItems().size()) {
            this.setItemDescription(index, this.myDescription.getText());
        }
    }
}

