/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.core.utils.CdataString;
import com.tssap.j2ee.ui.CdataStringEditor;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class CdataStringCellEditor
extends CellEditor {
    private Composite myEditor;
    private Text myContents;
    private Button myButton;
    private Object myValue;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private ModifyListener modifyListener;

    public CdataStringCellEditor(Composite parent) {
        super(parent);
    }

    protected Object doGetValue() {
        return this.myValue;
    }

    protected void doSetValue(Object value) {
        this.myValue = value;
        this.updateContents();
    }

    protected void updateContents() {
        if (this.myContents == null || this.myContents.isDisposed()) {
            return;
        }
        this.myContents.removeModifyListener(this.getModifyListener());
        this.myContents.setText(this.myValue == null ? "" : this.myValue.toString());
        this.myContents.addModifyListener(this.getModifyListener());
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.myEditor = new Composite(parent, this.getStyle());
        this.myEditor.setFont(font);
        this.myEditor.setBackground(bg);
        this.myEditor.setLayout((Layout)new CdataStringCellEditorLayout());
        this.myContents = new Text(this.myEditor, 4);
        this.myContents.setFont(font);
        this.myContents.setBackground(bg);
        this.myContents.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CdataStringCellEditor.this.checkSelection();
                CdataStringCellEditor.this.checkDeleteable();
                CdataStringCellEditor.this.checkSelectable();
            }
        });
        this.myContents.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CdataStringCellEditor.super.keyReleaseOccured(e);
                if (CdataStringCellEditor.this.getControl() == null || CdataStringCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                CdataStringCellEditor.this.checkSelection();
                CdataStringCellEditor.this.checkDeleteable();
                CdataStringCellEditor.this.checkSelectable();
            }
        });
        this.myContents.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.myContents.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (CdataStringCellEditor.this.isActivated()) {
                    CdataStringCellEditor.super.fireApplyEditorValue();
                }
            }
        });
        this.myContents.addModifyListener(this.getModifyListener());
        this.updateContents();
        this.myButton = new Button(this.myEditor, 1024);
        this.myButton.setText("cdata");
        this.myButton.setFont(font);
        this.myButton.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    CdataStringCellEditor.super.fireCancelEditor();
                }
            }
        });
        this.myButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object newValue = CdataStringCellEditor.this.openDialogBox((Control)CdataStringCellEditor.this.myEditor);
                if (newValue == null) {
                    return;
                }
                CdataStringCellEditor.this.doSetValue(newValue);
                CdataStringCellEditor.this.doSetFocus();
                boolean oldValidState = CdataStringCellEditor.this.isValueValid();
                boolean newValidState = CdataStringCellEditor.super.isCorrect(newValue);
                CdataStringCellEditor.super.valueChanged(oldValidState, newValidState);
                if (!newValidState) {
                    CdataStringCellEditor.super.setErrorMessage(MessageFormat.format(CdataStringCellEditor.this.getErrorMessage(), String.valueOf(newValue)));
                }
            }
        });
        this.setValueValid(true);
        return this.myEditor;
    }

    protected void doSetFocus() {
        if (this.myContents == null || this.myContents.isDisposed()) {
            return;
        }
        this.myContents.selectAll();
        this.myContents.setFocus();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        CdataStringEditor editor = new CdataStringEditor(cellEditorWindow.getShell());
        if (this.myValue != null) {
            editor.setText(this.myValue.toString());
        }
        if (editor.open() == 0) {
            return new CdataString(editor.getText());
        }
        return null;
    }

    protected void editOccured(ModifyEvent e) {
        this.myValue = this.myContents.getText();
        if (this.myValue == null) {
            this.myValue = "";
        }
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(this.myValue);
        this.valueChanged(oldValidState, newValidState);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.myValue));
        }
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CdataStringCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.myContents.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    public boolean isCopyEnabled() {
        if (this.myContents == null || this.myContents.isDisposed()) {
            return false;
        }
        return this.myContents.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.myContents == null || this.myContents.isDisposed()) {
            return false;
        }
        return this.myContents.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.myContents == null || this.myContents.isDisposed()) {
            return false;
        }
        return this.myContents.getSelectionCount() > 0 || this.myContents.getCaretPosition() < this.myContents.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.myContents != null && !this.myContents.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.myContents != null && !this.myContents.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.myContents == null || this.myContents.isDisposed()) {
            return false;
        }
        return this.myContents.getCharCount() > 0;
    }

    public void performCopy() {
        this.myContents.copy();
    }

    public void performCut() {
        this.myContents.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.myContents.getSelectionCount() > 0) {
            this.myContents.insert("");
        } else {
            int pos = this.myContents.getCaretPosition();
            if (pos < this.myContents.getCharCount()) {
                this.myContents.setSelection(pos, pos + 1);
                this.myContents.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.myContents.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.myContents.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    private class CdataStringCellEditorLayout
    extends Layout {
        private CdataStringCellEditorLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = CdataStringCellEditor.this.myButton.computeSize(-1, -1, force);
            if (CdataStringCellEditor.this.myContents != null) {
                CdataStringCellEditor.this.myContents.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            CdataStringCellEditor.this.myButton.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = CdataStringCellEditor.this.myContents.computeSize(-1, -1, force);
            Point buttonSize = CdataStringCellEditor.this.myButton.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

