/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameCompilationUnitRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameJavaProjectRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameSourceFolderRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringPreferences;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSupport;
import org.eclipse.jdt.internal.ui.reorg.IRefactoringRenameSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;

public class RenameSupport {
    private IRefactoringRenameSupport fSupport;
    private IJavaElement fElement;
    private RefactoringStatus fPreCheckStatus;
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    public static final int UPDATE_JAVADOC_COMMENTS = 2;
    public static final int UPDATE_REGULAR_COMMENTS = 4;
    public static final int UPDATE_STRING_LITERALS = 8;
    public static final int UPDATE_GETTER_METHOD = 16;
    public static final int UPDATE_SETTER_METHOD = 32;

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return this.fPreCheckStatus.getFirstEntry(4).asStatus();
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    public void openDialog(Shell parent) throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            this.showInformation(parent, this.fPreCheckStatus);
            return;
        }
        this.fSupport.rename(parent, this.fElement);
    }

    public void perform(Shell parent, IRunnableContext context) throws InterruptedException, InvocationTargetException {
        try {
            this.ensureChecked();
            if (this.fPreCheckStatus.hasFatalError()) {
                this.showInformation(parent, this.fPreCheckStatus);
                return;
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        RefactoringExecutionHelper helper = new RefactoringExecutionHelper(this.fSupport.getRefactoring(), RefactoringPreferences.getStopSeverity(), parent, context);
        helper.perform();
    }

    private RenameSupport(IRefactoringRenameSupport support, IJavaElement element) {
        this.fSupport = support;
        this.fElement = element;
    }

    public static RenameSupport create(IJavaProject project, String newName, int flags) throws CoreException {
        RefactoringSupport.JavaProject support = new RefactoringSupport.JavaProject(project);
        RenameJavaProjectRefactoring refactoring = support.getSpecificRefactoring();
        RenameSupport.setNewName(refactoring, newName);
        refactoring.setUpdateReferences(RenameSupport.updateReferences(flags));
        return new RenameSupport(support, (IJavaElement)project);
    }

    public static RenameSupport create(IPackageFragmentRoot root, String newName) throws CoreException {
        RefactoringSupport.SourceFolder support = new RefactoringSupport.SourceFolder(root);
        RenameSourceFolderRefactoring refactoring = support.getSpecificRefactoring();
        RenameSupport.setNewName(refactoring, newName);
        return new RenameSupport(support, (IJavaElement)root);
    }

    public static RenameSupport create(IPackageFragment fragment, String newName, int flags) throws CoreException {
        RefactoringSupport.PackageFragment support = new RefactoringSupport.PackageFragment(fragment);
        RenamePackageRefactoring refactoring = support.getSpecificRefactoring();
        RenameSupport.setNewName(refactoring, newName);
        refactoring.setUpdateReferences(RenameSupport.updateReferences(flags));
        refactoring.setUpdateJavaDoc(RenameSupport.updateJavadocComments(flags));
        refactoring.setUpdateComments(RenameSupport.updateRegularComments(flags));
        refactoring.setUpdateStrings(RenameSupport.updateStringLiterals(flags));
        return new RenameSupport(support, (IJavaElement)fragment);
    }

    public static RenameSupport create(ICompilationUnit unit, String newName, int flags) throws CoreException {
        RefactoringSupport.CompilationUnit support = new RefactoringSupport.CompilationUnit(unit);
        RenameCompilationUnitRefactoring refactoring = support.getSpecificRefactoring();
        RenameSupport.setNewName(refactoring, newName);
        refactoring.setUpdateReferences(RenameSupport.updateReferences(flags));
        refactoring.setUpdateJavaDoc(RenameSupport.updateJavadocComments(flags));
        refactoring.setUpdateComments(RenameSupport.updateRegularComments(flags));
        refactoring.setUpdateStrings(RenameSupport.updateStringLiterals(flags));
        return new RenameSupport(support, (IJavaElement)unit);
    }

    public static RenameSupport create(IType type, String newName, int flags) throws CoreException {
        RefactoringSupport.Type support = new RefactoringSupport.Type(type);
        RenameTypeRefactoring refactoring = support.getSpecificRefactoring();
        RenameSupport.setNewName(refactoring, newName);
        refactoring.setUpdateReferences(RenameSupport.updateReferences(flags));
        refactoring.setUpdateJavaDoc(RenameSupport.updateJavadocComments(flags));
        refactoring.setUpdateComments(RenameSupport.updateRegularComments(flags));
        refactoring.setUpdateStrings(RenameSupport.updateStringLiterals(flags));
        return new RenameSupport(support, (IJavaElement)type);
    }

    public static RenameSupport create(IMethod method, String newName, int flags) throws CoreException {
        RefactoringSupport.Method support = new RefactoringSupport.Method(method);
        RenameMethodRefactoring refactoring = support.getSpecificRefactoring();
        RenameSupport.setNewName(refactoring, newName);
        refactoring.setUpdateReferences(RenameSupport.updateReferences(flags));
        return new RenameSupport(support, (IJavaElement)method);
    }

    public static RenameSupport create(IField field, String newName, int flags) throws CoreException {
        RefactoringSupport.Field support = new RefactoringSupport.Field(field);
        RenameFieldRefactoring refactoring = support.getSpecificRefactoring();
        RenameSupport.setNewName(refactoring, newName);
        refactoring.setUpdateReferences(RenameSupport.updateReferences(flags));
        refactoring.setUpdateJavaDoc(RenameSupport.updateJavadocComments(flags));
        refactoring.setUpdateComments(RenameSupport.updateRegularComments(flags));
        refactoring.setUpdateStrings(RenameSupport.updateStringLiterals(flags));
        refactoring.setRenameGetter(RenameSupport.updateGetterMethod(flags));
        refactoring.setRenameSetter(RenameSupport.updateSetterMethod(flags));
        return new RenameSupport(support, (IJavaElement)field);
    }

    private static void setNewName(IRenameRefactoring refactoring, String newName) {
        if (newName != null) {
            refactoring.setNewName(newName);
        }
    }

    private static boolean updateReferences(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean updateJavadocComments(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean updateRegularComments(int flags) {
        return (flags & 4) != 0;
    }

    private static boolean updateStringLiterals(int flags) {
        return (flags & 8) != 0;
    }

    private static boolean updateGetterMethod(int flags) {
        return (flags & 0x10) != 0;
    }

    private static boolean updateSetterMethod(int flags) {
        return (flags & 0x20) != 0;
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = this.fSupport.lightCheck();
        }
    }

    private void showInformation(Shell parent, RefactoringStatus status) {
        String message = status.getFirstMessage(4);
        MessageDialog.openInformation((Shell)parent, (String)this.fSupport.getRefactoring().getName(), (String)message);
    }
}

