/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.jarpackager;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarFileExportOperation;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageReader;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageWriter;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackager.ManifestProvider;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionWriter;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;
import org.eclipse.jdt.ui.jarpackager.JarWriter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;

public class JarPackageData {
    private String fManifestVersion;
    private boolean fExportClassFiles;
    private boolean fExportJavaFiles;
    private boolean fUseSourceFolderHierarchy;
    private boolean fBuildIfNeeded;
    private Object[] fElements;
    private IPath fJarLocation;
    private boolean fOverwrite;
    private boolean fCompress;
    private boolean fSaveDescription;
    private IPath fDescriptionLocation;
    private boolean fUsesManifest;
    private boolean fSaveManifest;
    private boolean fReuseManifest;
    private boolean fGenerateManifest;
    private IPath fManifestLocation;
    private boolean fSealJar;
    private IPackageFragment[] fPackagesToSeal;
    private IPackageFragment[] fPackagesToUnseal;
    private IType fManifestMainClass;
    private String fComment;
    private boolean fExportErrors;
    private boolean fExportWarnings;
    private IManifestProvider fManifestProvider;

    public JarPackageData() {
        this.setExportClassFiles(true);
        this.setUseSourceFolderHierarchy(false);
        this.setCompress(true);
        this.setSaveDescription(false);
        this.setJarLocation((IPath)new Path(""));
        this.setDescriptionLocation((IPath)new Path(""));
        this.setUsesManifest(true);
        this.setGenerateManifest(true);
        this.setReuseManifest(false);
        this.setSaveManifest(false);
        this.setManifestLocation((IPath)new Path(""));
        this.setExportErrors(true);
        this.setExportWarnings(true);
        this.setBuildIfNeeded(true);
    }

    public boolean isCompressed() {
        return this.fCompress;
    }

    public void setCompress(boolean state) {
        this.fCompress = state;
    }

    public boolean allowOverwrite() {
        return this.fOverwrite;
    }

    public void setOverwrite(boolean state) {
        this.fOverwrite = state;
    }

    public boolean areClassFilesExported() {
        return this.fExportClassFiles;
    }

    public void setExportClassFiles(boolean state) {
        this.fExportClassFiles = state;
    }

    public boolean areJavaFilesExported() {
        return this.fExportJavaFiles;
    }

    public void setExportJavaFiles(boolean state) {
        this.fExportJavaFiles = state;
    }

    public boolean useSourceFolderHierarchy() {
        return this.fUseSourceFolderHierarchy;
    }

    public void setUseSourceFolderHierarchy(boolean state) {
        this.fUseSourceFolderHierarchy = state;
    }

    public IPath getJarLocation() {
        return this.fJarLocation;
    }

    public void setJarLocation(IPath jarLocation) {
        this.fJarLocation = jarLocation;
    }

    public boolean isManifestGenerated() {
        return this.fGenerateManifest;
    }

    public void setGenerateManifest(boolean state) {
        this.fGenerateManifest = state;
    }

    public boolean isManifestSaved() {
        return this.fSaveManifest;
    }

    public void setSaveManifest(boolean state) {
        this.fSaveManifest = state;
        if (!this.fSaveManifest) {
            this.setReuseManifest(false);
        }
    }

    public boolean isManifestReused() {
        return this.fReuseManifest;
    }

    public void setReuseManifest(boolean state) {
        this.fReuseManifest = state;
        if (this.fReuseManifest) {
            this.setSaveManifest(true);
        }
    }

    public IPath getManifestLocation() {
        return this.fManifestLocation;
    }

    public void setManifestLocation(IPath manifestLocation) {
        this.fManifestLocation = manifestLocation;
    }

    public IFile getManifestFile() {
        IPath path = this.getManifestLocation();
        if (path.isValidPath(path.toString()) && path.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(path);
        }
        return null;
    }

    public String getManifestVersion() {
        if (this.fManifestVersion == null) {
            return "1.0";
        }
        return this.fManifestVersion;
    }

    public void setManifestVersion(String manifestVersion) {
        this.fManifestVersion = manifestVersion;
    }

    public boolean usesManifest() {
        return this.fUsesManifest;
    }

    public void setUsesManifest(boolean state) {
        this.fUsesManifest = state;
    }

    public IManifestProvider getManifestProvider() {
        if (this.fManifestProvider == null) {
            this.fManifestProvider = new ManifestProvider();
        }
        return this.fManifestProvider;
    }

    public void setManifestProvider(IManifestProvider manifestProvider) {
        this.fManifestProvider = manifestProvider;
    }

    public boolean isJarSealed() {
        return this.fSealJar;
    }

    public void setSealJar(boolean sealJar) {
        this.fSealJar = sealJar;
    }

    public void setPackagesToSeal(IPackageFragment[] packagesToSeal) {
        this.fPackagesToSeal = packagesToSeal;
    }

    public IPackageFragment[] getPackagesToSeal() {
        if (this.fPackagesToSeal == null) {
            return new IPackageFragment[0];
        }
        return this.fPackagesToSeal;
    }

    public IPackageFragment[] getPackagesToUnseal() {
        if (this.fPackagesToUnseal == null) {
            return new IPackageFragment[0];
        }
        return this.fPackagesToUnseal;
    }

    public void setPackagesToUnseal(IPackageFragment[] packagesToUnseal) {
        this.fPackagesToUnseal = packagesToUnseal;
    }

    public boolean isDescriptionSaved() {
        return this.fSaveDescription;
    }

    public void setSaveDescription(boolean state) {
        this.fSaveDescription = state;
    }

    public IPath getDescriptionLocation() {
        return this.fDescriptionLocation;
    }

    public void setDescriptionLocation(IPath descriptionLocation) {
        this.fDescriptionLocation = descriptionLocation;
    }

    public IFile getDescriptionFile() {
        IPath path = this.getDescriptionLocation();
        if (path.isValidPath(path.toString()) && path.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(path);
        }
        return null;
    }

    public IType getManifestMainClass() {
        return this.fManifestMainClass;
    }

    public void setManifestMainClass(IType manifestMainClass) {
        this.fManifestMainClass = manifestMainClass;
    }

    public Object[] getElements() {
        if (this.fElements == null) {
            this.setElements(new Object[0]);
        }
        return this.fElements;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public boolean logErrors() {
        return true;
    }

    public void setLogErrors(boolean logErrors) {
    }

    public boolean logWarnings() {
        return true;
    }

    public void setLogWarnings(boolean logWarnings) {
    }

    public boolean areErrorsExported() {
        return this.fExportErrors;
    }

    public void setExportErrors(boolean exportErrors) {
        this.fExportErrors = exportErrors;
    }

    public boolean exportWarnings() {
        return this.fExportWarnings;
    }

    public void setExportWarnings(boolean exportWarnings) {
        this.fExportWarnings = exportWarnings;
    }

    public boolean isBuildingIfNeeded() {
        return this.fBuildIfNeeded;
    }

    public void setBuildIfNeeded(boolean fBuildIfNeeded) {
        this.fBuildIfNeeded = fBuildIfNeeded;
    }

    public IFile[] findClassfilesFor(IFile javaFile) throws CoreException {
        return null;
    }

    public JarWriter createJarWriter(Shell parent) throws CoreException {
        return new JarWriter(this, parent);
    }

    public IJarExportRunnable createJarExportRunnable(Shell parent) {
        return new JarFileExportOperation(this, parent);
    }

    public IJarExportRunnable createJarExportRunnable(JarPackageData[] jarPackagesData, Shell parent) {
        return new JarFileExportOperation(jarPackagesData, parent);
    }

    public IJarDescriptionWriter createJarDescriptionWriter(OutputStream outputStream) {
        return new JarPackageWriter(outputStream);
    }

    public IJarDescriptionReader createJarDescriptionReader(InputStream inputStream) {
        return new JarPackageReader(inputStream);
    }

    public boolean isValid() {
        return (this.areClassFilesExported() || this.areJavaFilesExported()) && this.getElements() != null && this.getElements().length > 0 && this.getJarLocation() != null && this.isManifestAccessible() && this.isMainClassValid(new BusyIndicatorRunnableContext());
    }

    public boolean isManifestAccessible() {
        if (this.isManifestGenerated()) {
            return true;
        }
        IFile file = this.getManifestFile();
        return file != null && file.isAccessible();
    }

    public boolean isMainClassValid(IRunnableContext context) {
        return JarPackagerUtil.isMainClassValid(this, context);
    }
}

