/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSupertypeWherePossibleRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.UseSupertypeWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class UseSupertypeAction
extends SelectionDispatchAction {
    private UseSupertypeWherePossibleRefactoring fRefactoring;
    private CompilationUnitEditor fEditor;

    public UseSupertypeAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public UseSupertypeAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("UseSupertypeAction.use_Supertype"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.use_supertype_action");
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
        if (!this.isEnabled()) {
            this.fRefactoring = null;
        }
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    protected void run(IStructuredSelection selection) {
        if (this.fRefactoring == null) {
            this.selectionChanged(selection);
        }
        if (this.isEnabled()) {
            this.startRefactoring();
        }
        this.fRefactoring = null;
        this.selectionChanged(selection);
    }

    protected void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        if (this.canRun(selection)) {
            this.startRefactoring();
        } else {
            String unavailable = RefactoringMessages.getString("UseSupertypeAction.to_activate");
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("OpenRefactoringWizardAction.unavailable"), (String)unavailable);
        }
        this.fRefactoring = null;
        this.selectionChanged(selection);
    }

    private boolean canEnable(IStructuredSelection selection) {
        try {
            if (selection.isEmpty() || selection.size() != 1) {
                return false;
            }
            Object first = selection.getFirstElement();
            if (first instanceof IType) {
                return this.shouldAcceptElement((IType)first);
            }
            if (first instanceof ICompilationUnit) {
                return this.shouldAcceptElement(JavaElementUtil.getMainType((ICompilationUnit)first));
            }
            return false;
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            return false;
        }
    }

    private boolean canRun(ITextSelection selection) {
        IJavaElement[] elements = this.resolveElements();
        if (elements.length != 1) {
            return false;
        }
        return this.canRunOn(elements[0]);
    }

    private boolean canRunOn(IJavaElement element) {
        return element instanceof IType && element.exists() && this.shouldAcceptElement((IType)element);
    }

    private boolean shouldAcceptElement(IType type) {
        if (type == null) {
            return false;
        }
        try {
            this.fRefactoring = new UseSupertypeWherePossibleRefactoring(type, JavaPreferencesSettings.getCodeGenerationSettings());
            return this.fRefactoring.checkPreactivation().isOK();
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            return false;
        }
    }

    private IJavaElement[] resolveElements() {
        return SelectionConverter.codeResolveHandled(this.fEditor, this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"));
    }

    private RefactoringWizard createWizard() {
        return new UseSupertypeWizard(this.fRefactoring);
    }

    private void startRefactoring() {
        Assert.isNotNull(this.fRefactoring);
        if (!ActionUtil.isProcessable(this.getShell(), this.fRefactoring.getInputType())) {
            return;
        }
        try {
            Object newElementToProcess = new RefactoringStarter().activate(this.fRefactoring, this.createWizard(), this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), true);
            if (newElementToProcess == null) {
                return;
            }
            StructuredSelection mockSelection = new StructuredSelection(newElementToProcess);
            this.selectionChanged((IStructuredSelection)mockSelection);
            if (this.isEnabled()) {
                this.run((IStructuredSelection)mockSelection);
            } else {
                MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)RefactoringMessages.getString("UseSupertypeAction.Refactoring"), (String)RefactoringMessages.getString("UseSupertypeAction.not_possible"));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }
}

