/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ShowInPackageViewAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ShowInPackageViewAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("ShowInPackageViewAction.label"));
        this.setDescription(ActionMessages.getString("ShowInPackageViewAction.description"));
        this.setToolTipText(ActionMessages.getString("ShowInPackageViewAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.show_in_packageview_action_context");
    }

    public ShowInPackageViewAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IJavaElement;
    }

    protected void run(ITextSelection selection) {
        try {
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null) {
                this.run(element);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            String message = ActionMessages.getString("ShowInPackageViewAction.error.message");
            ErrorDialog.openError((Shell)this.getShell(), (String)ShowInPackageViewAction.getDialogTitle(), (String)message, (IStatus)e.getStatus());
        }
    }

    protected void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run((IJavaElement)selection.getFirstElement());
    }

    private void run(IJavaElement element) {
        PackageExplorerPart view;
        if (element == null) {
            return;
        }
        IOpenable openable = element.getOpenable();
        if (openable instanceof IJavaElement) {
            element = (IJavaElement)openable;
        }
        if ((view = PackageExplorerPart.openInActivePerspective()) != null) {
            if (this.reveal(view, element)) {
                return;
            }
            if ((element = this.getVisibleParent(element)) != null) {
                if (this.reveal(view, element)) {
                    return;
                }
                IResource resource = element.getResource();
                if (resource != null && this.reveal(view, resource)) {
                    return;
                }
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)ShowInPackageViewAction.getDialogTitle(), (String)ActionMessages.getString("ShowInPackageViewAction.not_found"));
        }
    }

    private boolean reveal(PackageExplorerPart view, Object element) {
        if (element == null) {
            return false;
        }
        view.selectReveal((ISelection)new StructuredSelection(element));
        IElementComparer comparer = view.getTreeViewer().getComparer();
        Object selected = this.getSelectedElement(view);
        return comparer != null ? comparer.equals(element, selected) : element.equals(selected);
    }

    private Object getSelectedElement(PackageExplorerPart view) {
        return ((IStructuredSelection)view.getSite().getSelectionProvider().getSelection()).getFirstElement();
    }

    private IJavaElement getVisibleParent(IJavaElement element) {
        ICompilationUnit unit;
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                element = (IJavaElement)element.getOpenable();
                break;
            }
            case 1: {
                element = null;
            }
        }
        if (element.getElementType() == 5 && (unit = (ICompilationUnit)element).isWorkingCopy()) {
            element = unit.getOriginalElement();
        }
        return element;
    }

    private static String getDialogTitle() {
        return ActionMessages.getString("ShowInPackageViewAction.dialog.title");
    }
}

