/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ShowInNavigatorViewAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ShowInNavigatorViewAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("ShowInNavigatorView.label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.show_in_navigator_action");
    }

    public ShowInNavigatorViewAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getResource(selection) != null);
    }

    protected void run(ITextSelection selection) {
        IJavaElement input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        IJavaElement element = SelectionConverter.codeResolveOrInputHandled(this.fEditor, this.getShell(), ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.getString("ShowInNavigatorView.dialog.message"));
        if (element == null) {
            return;
        }
        this.run(this.getResource(element));
    }

    protected void run(IStructuredSelection selection) {
        this.run(this.getResource(selection));
    }

    private void run(IResource resource) {
        if (resource == null) {
            return;
        }
        try {
            IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
            IViewPart view = page.showView("org.eclipse.ui.views.ResourceNavigator");
            if (view instanceof ISetSelectionTarget) {
                StructuredSelection selection = new StructuredSelection((Object)resource);
                ((ISetSelectionTarget)view).selectReveal((ISelection)selection);
            }
        }
        catch (PartInitException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.getString("ShowInNavigatorView.error.activation_failed"));
        }
    }

    private IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IJavaElement) {
            return this.getResource((IJavaElement)element);
        }
        return null;
    }

    private IResource getResource(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if ((element = (IJavaElement)element.getOpenable()) instanceof ICompilationUnit) {
            element = JavaModelUtil.toOriginal((ICompilationUnit)element);
        }
        return element.getResource();
    }

    private static String getDialogTitle() {
        return ActionMessages.getString("ShowInNavigatorView.dialog.title");
    }
}

