/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.sef.SelfEncapsulateFieldWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class SelfEncapsulateFieldAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public SelfEncapsulateFieldAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("SelfEncapsulateFieldAction.label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.self_encapsulate_action");
    }

    public SelfEncapsulateFieldAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IField)) {
            return false;
        }
        return !((IField)element).isBinary();
    }

    protected void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        IJavaElement[] elements = SelectionConverter.codeResolveHandled(this.fEditor, this.getShell(), this.getDialogTitle());
        if (elements.length != 1 || !(elements[0] instanceof IField)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.getString("SelfEncapsulateFieldAction.dialog.unavailable"));
            return;
        }
        IField field = (IField)elements[0];
        if (field.isBinary()) {
            return;
        }
        this.run(field);
    }

    protected void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run((IField)selection.getFirstElement());
    }

    private void run(IField selectedField) {
        if (!ActionUtil.isProcessable(this.getShell(), selectedField)) {
            return;
        }
        IField field = null;
        try {
            field = (IField)WorkingCopyUtil.getWorkingCopyIfExists((IMember)selectedField);
        }
        catch (JavaModelException javaModelException) {}
        if (field == null) {
            MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)this.getDialogTitle(), (String)ActionMessages.getFormattedString("SelfEncapsulateFieldAction.dialog.field_doesnot_exit", selectedField.getElementName()));
            return;
        }
        try {
            SelfEncapsulateFieldRefactoring refactoring = new SelfEncapsulateFieldRefactoring(field, JavaPreferencesSettings.getCodeGenerationSettings());
            new RefactoringStarter().activate(refactoring, new SelfEncapsulateFieldWizard(refactoring), this.getShell(), this.getDialogTitle(), true);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getDialogTitle(), ActionMessages.getString("SelfEncapsulateFieldAction.dialog.cannot_perform"));
        }
    }

    private String getDialogTitle() {
        return ActionMessages.getString("SelfEncapsulateFieldAction.dialog.title");
    }
}

