/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RenameJavaElementAction;
import org.eclipse.jdt.internal.ui.refactoring.actions.RenameResourceAction;
import org.eclipse.jdt.internal.ui.refactoring.actions.RenameTempAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class RenameAction
extends SelectionDispatchAction {
    private RenameJavaElementAction fRenameJavaElement;
    private RenameResourceAction fRenameResource;
    private RenameTempAction fRenameTemp;
    private CompilationUnitEditor fEditor;

    public RenameAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("RenameAction.text"));
        this.fRenameJavaElement = new RenameJavaElementAction(site);
        this.fRenameJavaElement.setText(this.getText());
        this.fRenameResource = new RenameResourceAction(site);
        this.fRenameResource.setText(this.getText());
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.rename_action");
    }

    public RenameAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.fRenameTemp = new RenameTempAction(this.fEditor);
        this.fRenameJavaElement = new RenameJavaElementAction(editor);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fRenameJavaElement.selectionChanged(event);
        if (this.fRenameResource != null) {
            this.fRenameResource.selectionChanged(event);
        }
        if (this.fRenameTemp != null) {
            this.fRenameTemp.selectionChanged(event);
        }
        this.setEnabled(this.computeEnabledState());
    }

    public void update(ISelection selection) {
        this.fRenameJavaElement.update(selection);
        if (this.fRenameResource != null) {
            this.fRenameResource.update(selection);
        }
        if (this.fRenameTemp != null) {
            this.fRenameTemp.update(selection);
        }
        this.setEnabled(this.computeEnabledState());
    }

    private boolean computeEnabledState() {
        if (this.fRenameTemp != null) {
            return this.fRenameJavaElement.isEnabled() || this.fRenameTemp.isEnabled();
        }
        if (this.fRenameResource != null) {
            return this.fRenameJavaElement.isEnabled() || this.fRenameResource.isEnabled();
        }
        return this.fRenameJavaElement.isEnabled();
    }

    protected void run(IStructuredSelection selection) {
        if (this.fRenameJavaElement.isEnabled()) {
            ((SelectionDispatchAction)this.fRenameJavaElement).run(selection);
        }
        if (this.fRenameResource != null && this.fRenameResource.isEnabled()) {
            this.fRenameResource.run(selection);
        }
    }

    protected void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        if (this.fRenameTemp != null && this.fRenameTemp.canRun(selection)) {
            ((SelectionDispatchAction)this.fRenameTemp).run(selection);
        } else if (this.fRenameJavaElement.canRun(selection)) {
            ((SelectionDispatchAction)this.fRenameJavaElement).run(selection);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("RenameAction.rename"), (String)RefactoringMessages.getString("RenameAction.unavailable"));
        }
    }
}

