/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.PullUpWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class PullUpAction
extends SelectionDispatchAction {
    private PullUpRefactoring fRefactoring;
    private CompilationUnitEditor fEditor;

    public PullUpAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("RefactoringGroup.pull_Up_label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.pull_up_action");
    }

    public PullUpAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
        if (!this.isEnabled()) {
            this.fRefactoring = null;
        }
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    protected void run(IStructuredSelection selection) {
        if (this.fRefactoring == null) {
            this.selectionChanged(selection);
        }
        if (this.isEnabled()) {
            this.startRefactoring();
        }
        this.fRefactoring = null;
        this.selectionChanged(selection);
    }

    protected void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        if (this.canRun(selection)) {
            this.startRefactoring();
        } else {
            String unavailable = RefactoringMessages.getString("PullUpAction.unavailable");
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("OpenRefactoringWizardAction.unavailable"), (String)unavailable);
        }
        this.fRefactoring = null;
        this.selectionChanged(selection);
    }

    private boolean canEnable(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof IMember) continue;
            return false;
        }
        return this.shouldAcceptElements(selection.toArray());
    }

    private boolean canRun(ITextSelection selection) {
        try {
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element == null) {
                return false;
            }
            return element instanceof IMember && this.shouldAcceptElements(new IJavaElement[]{element});
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            return false;
        }
    }

    private PullUpRefactoring createNewRefactoringInstance(Object[] obj) {
        return new PullUpRefactoring(this.convertToMemberArray(obj), JavaPreferencesSettings.getCodeGenerationSettings());
    }

    private IMember[] convertToMemberArray(Object[] obj) {
        HashSet<Object> memberSet = new HashSet<Object>();
        memberSet.addAll(Arrays.asList(obj));
        return memberSet.toArray(new IMember[memberSet.size()]);
    }

    private boolean shouldAcceptElements(Object[] elements) {
        try {
            this.fRefactoring = this.createNewRefactoringInstance(elements);
            return this.fRefactoring.checkPreactivation().isOK();
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            return false;
        }
    }

    private RefactoringWizard createWizard() {
        String title = RefactoringMessages.getString("RefactoringGroup.pull_up");
        String helpId = "org.eclipse.jdt.ui.pull_up_error_error_wizard_page_context";
        return new PullUpWizard(this.fRefactoring, title, helpId);
    }

    private void startRefactoring() {
        Assert.isNotNull(this.fRefactoring);
        if (!ActionUtil.isProcessable(this.getShell(), this.fRefactoring.getDeclaringType())) {
            return;
        }
        try {
            Object newElementToProcess = new RefactoringStarter().activate(this.fRefactoring, this.createWizard(), this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), true);
            if (newElementToProcess == null) {
                return;
            }
            StructuredSelection mockSelection = new StructuredSelection(newElementToProcess);
            this.selectionChanged((IStructuredSelection)mockSelection);
            if (this.isEnabled()) {
                this.run((IStructuredSelection)mockSelection);
            } else {
                MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)ActionMessages.getString("PullUpAction.problem.title"), (String)ActionMessages.getString("PullUpAction.problem.message"));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }
}

