/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.ui.actions.OpenProjectAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.CloseResourceAction;

public class ProjectActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private OpenProjectAction fOpenAction;
    private CloseResourceAction fCloseAction;

    public ProjectActionGroup(IViewPart part) {
        this.fSite = part.getSite();
        Shell shell = this.fSite.getShell();
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fOpenAction = new OpenProjectAction(this.fSite);
        this.fCloseAction = new CloseResourceAction(shell);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection s = (IStructuredSelection)selection;
            this.fOpenAction.selectionChanged(s);
            this.fCloseAction.selectionChanged(s);
        }
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.fCloseAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("closeProject", (IAction)this.fCloseAction);
        actionBars.setGlobalActionHandler("openProject", (IAction)this.fOpenAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.fOpenAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.fOpenAction);
        }
        if (this.fCloseAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.fCloseAction);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fCloseAction);
        super.dispose();
    }
}

