/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.MoveInstanceMethodAction;
import org.eclipse.jdt.internal.ui.refactoring.actions.MoveStaticMembersAction;
import org.eclipse.jdt.internal.ui.reorg.JdtMoveAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class MoveAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private SelectionDispatchAction fMoveInstanceMethodAction;
    private SelectionDispatchAction fMoveStaticMembersAction;
    private SelectionDispatchAction fJdtMoveAction;

    public MoveAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("MoveAction.text"));
        this.fMoveStaticMembersAction = new MoveStaticMembersAction(site);
        this.fMoveInstanceMethodAction = new MoveInstanceMethodAction(site);
        this.fJdtMoveAction = new JdtMoveAction(site);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.move_action");
    }

    public MoveAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(RefactoringMessages.getString("MoveAction.text"));
        this.fMoveStaticMembersAction = new MoveStaticMembersAction(editor);
        this.fMoveInstanceMethodAction = new MoveInstanceMethodAction(editor);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.move_action");
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fMoveStaticMembersAction.selectionChanged(event);
        this.fMoveInstanceMethodAction.selectionChanged(event);
        if (this.fJdtMoveAction != null) {
            this.fJdtMoveAction.selectionChanged(event);
        }
        this.setEnabled(this.computeEnableState());
    }

    protected void run(IStructuredSelection selection) {
        this.assertThatExactlyOneIsEnabled();
        if (this.fJdtMoveAction != null && this.fJdtMoveAction.isEnabled()) {
            this.fJdtMoveAction.run();
        } else if (this.fMoveInstanceMethodAction.isEnabled()) {
            this.fMoveInstanceMethodAction.run();
        } else if (this.fMoveStaticMembersAction.isEnabled()) {
            this.fMoveStaticMembersAction.run();
        }
    }

    private void assertThatExactlyOneIsEnabled() {
        Assert.isTrue(!this.fMoveInstanceMethodAction.isEnabled() || !this.fMoveStaticMembersAction.isEnabled());
        if (this.fJdtMoveAction != null) {
            Assert.isTrue(!this.fJdtMoveAction.isEnabled() || !this.fMoveInstanceMethodAction.isEnabled());
            Assert.isTrue(!this.fJdtMoveAction.isEnabled() || !this.fMoveStaticMembersAction.isEnabled());
            Assert.isTrue(this.fJdtMoveAction.isEnabled() || this.fMoveInstanceMethodAction.isEnabled() || this.fMoveStaticMembersAction.isEnabled());
        } else {
            Assert.isTrue(this.fMoveInstanceMethodAction.isEnabled() || this.fMoveStaticMembersAction.isEnabled());
        }
    }

    protected void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        if (this.fJdtMoveAction != null && this.fJdtMoveAction.isEnabled()) {
            this.fJdtMoveAction.run();
            return;
        }
        if (this.fMoveInstanceMethodAction.isEnabled() && this.tryMoveInstanceMethod(selection)) {
            return;
        }
        if (this.fMoveStaticMembersAction.isEnabled() && this.tryMoveStaticMembers(selection)) {
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("MoveAction.Move"), (String)RefactoringMessages.getString("MoveAction.select"));
    }

    private boolean tryMoveStaticMembers(ITextSelection selection) {
        try {
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element == null) {
                return false;
            }
            if (!(element instanceof IMember)) {
                return false;
            }
            MoveStaticMembersRefactoring refactoring = new MoveStaticMembersRefactoring(new IMember[]{(IMember)element}, JavaPreferencesSettings.getCodeGenerationSettings());
            if (!refactoring.checkPreactivation().isOK()) {
                return false;
            }
            this.fMoveStaticMembersAction.run(selection);
            return true;
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            return false;
        }
    }

    private boolean tryMoveInstanceMethod(ITextSelection selection) {
        try {
            MoveInstanceMethodRefactoring refactoring = MoveInstanceMethodRefactoring.create(this.getCompilationUnitForTextSelection(), selection.getOffset(), selection.getLength(), JavaPreferencesSettings.getCodeGenerationSettings());
            if (refactoring == null) {
                return false;
            }
            if (refactoring.checkActivation((IProgressMonitor)new NullProgressMonitor()).hasFatalError()) {
                return false;
            }
            this.fMoveInstanceMethodAction.run(selection);
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private ICompilationUnit getCompilationUnitForTextSelection() {
        Assert.isNotNull(this.fEditor);
        return SelectionConverter.getInputAsCompilationUnit(this.fEditor);
    }

    public void update(ISelection selection) {
        this.fMoveStaticMembersAction.update(selection);
        this.fMoveInstanceMethodAction.update(selection);
        if (this.fJdtMoveAction != null) {
            this.fJdtMoveAction.update(selection);
        }
        this.setEnabled(this.computeEnableState());
    }

    private boolean computeEnableState() {
        if (this.fMoveStaticMembersAction.isEnabled() || this.fMoveInstanceMethodAction.isEnabled()) {
            return true;
        }
        if (this.fJdtMoveAction == null) {
            return false;
        }
        return this.fJdtMoveAction.isEnabled();
    }
}

