/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.ChangeSignatureWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ModifyParametersAction
extends SelectionDispatchAction {
    private ChangeSignatureRefactoring fRefactoring;
    private CompilationUnitEditor fEditor;

    public ModifyParametersAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public ModifyParametersAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("RefactoringGroup.modify_Parameters_label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.modify_parameters_action");
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
        if (!this.isEnabled()) {
            this.fRefactoring = null;
        }
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    protected void run(IStructuredSelection selection) {
        if (this.fRefactoring == null) {
            this.selectionChanged(selection);
        }
        if (this.isEnabled()) {
            this.startRefactoring();
        }
        this.fRefactoring = null;
        this.selectionChanged(selection);
    }

    protected void run(ITextSelection selection) {
        if (this.canRun(selection)) {
            this.startRefactoring();
        } else {
            String unavailable = RefactoringMessages.getString("ModifyParametersAction.unavailable");
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("OpenRefactoringWizardAction.unavailable"), (String)unavailable);
        }
        this.fRefactoring = null;
        this.selectionChanged(selection);
    }

    private boolean canEnable(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IMethod && this.shouldAcceptElement((IMethod)first);
    }

    private boolean canRun(ITextSelection selection) {
        IJavaElement[] elements = this.resolveElements();
        if (elements.length > 1) {
            return false;
        }
        if (elements.length == 1) {
            return this.canRunOn(elements[0]);
        }
        try {
            IJavaElement selected = SelectionConverter.getInputAsCompilationUnit(this.fEditor).getElementAt(selection.getOffset());
            return this.canRunOn(selected);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
            return false;
        }
    }

    private boolean canRunOn(IJavaElement element) {
        return element instanceof IMethod && element.exists() && this.shouldAcceptElement((IMethod)element);
    }

    private boolean shouldAcceptElement(IMethod method) {
        try {
            this.fRefactoring = new ChangeSignatureRefactoring(method, JavaPreferencesSettings.getCodeGenerationSettings());
            return this.fRefactoring.checkPreactivation().isOK();
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            return false;
        }
    }

    private IJavaElement[] resolveElements() {
        return SelectionConverter.codeResolveHandled(this.fEditor, this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"));
    }

    private RefactoringWizard createWizard() {
        String title = RefactoringMessages.getString("RefactoringGroup.modify_method_parameters");
        String helpId = "org.eclipse.jdt.ui.modify_parameters_error_wizard_page_context";
        return new ChangeSignatureWizard(this.fRefactoring, title, helpId);
    }

    private void startRefactoring() {
        Assert.isNotNull(this.fRefactoring);
        if (!ActionUtil.isProcessable(this.getShell(), this.fRefactoring.getMethod())) {
            return;
        }
        try {
            Object newElementToProcess = new RefactoringStarter().activate(this.fRefactoring, this.createWizard(), this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), true);
            if (newElementToProcess == null) {
                return;
            }
            StructuredSelection mockSelection = new StructuredSelection(newElementToProcess);
            this.selectionChanged((IStructuredSelection)mockSelection);
            if (this.isEnabled()) {
                this.run((IStructuredSelection)mockSelection);
            } else {
                MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)ActionMessages.getString("ModifyParameterAction.problem.title"), (String)ActionMessages.getString("ModifyParameterAction.problem.message"));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }
}

