/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.InlineTempInputPage;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class InlineTempAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.getString("InlineTempAction.inline_temp");

    public InlineTempAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    InlineTempAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("InlineTempAction.label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.inline_action");
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    protected void run(ITextSelection selection) {
        try {
            ICompilationUnit input = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
            if (!ActionUtil.isProcessable(this.getShell(), input)) {
                return;
            }
            Refactoring refactoring = this.createRefactoring(input, selection);
            new RefactoringStarter().activate(refactoring, this.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }

    protected Refactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) {
        return new InlineTempRefactoring(cunit, selection.getOffset(), selection.getLength());
    }

    protected RefactoringWizard createWizard(Refactoring refactoring) {
        String helpId = "org.eclipse.jdt.ui.inline_temp_error_wizard_page_context";
        String pageTitle = RefactoringMessages.getString("InlineTempAction.inline_temp");
        RefactoringWizard result = new RefactoringWizard((InlineTempRefactoring)refactoring, pageTitle, helpId){

            protected void addUserInputPages() {
                this.addPage((IWizardPage)new InlineTempInputPage());
            }

            protected int getMessageLineWidthInChars() {
                return 0;
            }
        };
        result.setExpandFirstNode(true);
        return result;
    }

    protected void run(IStructuredSelection selection) {
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
    }
}

