/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.InlineConstantAction;
import org.eclipse.jdt.internal.ui.refactoring.actions.InlineMethodAction;
import org.eclipse.jdt.ui.actions.InlineTempAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class InlineAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private final InlineTempAction fInlineTemp;
    private final InlineMethodAction fInlineMethod;
    private final InlineConstantAction fInlineConstant;

    public InlineAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("InlineAction.Inline"));
        this.fInlineTemp = new InlineTempAction(site);
        this.fInlineMethod = new InlineMethodAction(site);
        this.fInlineConstant = new InlineConstantAction(site);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.inline_action");
    }

    public InlineAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.getString("InlineAction.Inline"));
        this.fEditor = editor;
        this.fInlineTemp = new InlineTempAction(editor);
        this.fInlineMethod = new InlineMethodAction(editor);
        this.fInlineConstant = new InlineConstantAction(editor);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.inline_action");
        this.setEnabled(this.getCompilationUnit() != null);
    }

    protected void selectionChanged(ISelection selection) {
        this.fInlineConstant.update(selection);
        this.fInlineMethod.update(selection);
        this.fInlineTemp.update(selection);
        this.setEnabled(this.computeEnablementState());
    }

    private boolean computeEnablementState() {
        return this.fInlineTemp.isEnabled() || this.fInlineConstant.isEnabled() || this.fInlineMethod.isEnabled();
    }

    protected void run(ITextSelection selection) {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null || !ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        if (this.fInlineTemp.isEnabled() && this.tryInlineTemp(cu, selection)) {
            return;
        }
        if (this.fInlineMethod.isEnabled() && this.tryInlineMethod(cu, selection)) {
            return;
        }
        if (this.fInlineConstant.isEnabled() && this.tryInlineConstant(cu, selection)) {
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("InlineAction.dialog_title"), (String)RefactoringMessages.getString("InlineAction.select"));
    }

    private boolean tryInlineTemp(ICompilationUnit cu, ITextSelection selection) {
        InlineTempRefactoring inlineTemp = new InlineTempRefactoring(cu, selection.getOffset(), selection.getLength());
        if (inlineTemp.checkIfTempSelectedSelected().hasFatalError()) {
            return false;
        }
        this.fInlineTemp.run(selection);
        return true;
    }

    private boolean tryInlineMethod(ICompilationUnit cu, ITextSelection selection) {
        InlineMethodRefactoring inlineMethodRef = InlineMethodRefactoring.create(cu, selection.getOffset(), selection.getLength(), JavaPreferencesSettings.getCodeGenerationSettings());
        if (inlineMethodRef == null) {
            return false;
        }
        ((SelectionDispatchAction)this.fInlineMethod).run(selection);
        return true;
    }

    private boolean tryInlineConstant(ICompilationUnit cu, ITextSelection selection) {
        InlineConstantRefactoring inlineConstantRef = InlineConstantRefactoring.create(cu, selection.getOffset(), selection.getLength(), JavaPreferencesSettings.getCodeGenerationSettings());
        if (inlineConstantRef == null || inlineConstantRef.checkStaticFinalConstantNameSelected().hasFatalError()) {
            return false;
        }
        ((SelectionDispatchAction)this.fInlineConstant).run(selection);
        return true;
    }

    private ICompilationUnit getCompilationUnit() {
        return SelectionConverter.getInputAsCompilationUnit(this.fEditor);
    }

    protected void run(IStructuredSelection selection) {
        if (this.fInlineConstant.isEnabled()) {
            ((SelectionDispatchAction)this.fInlineConstant).run(selection);
        } else if (this.fInlineMethod.isEnabled()) {
            ((SelectionDispatchAction)this.fInlineMethod).run(selection);
        } else {
            Assert.isTrue(!this.fInlineTemp.isEnabled());
        }
    }
}

