/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchOperation;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultCollector;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class FindAction
extends SelectionDispatchAction {
    private static final IJavaElement RETURN_WITHOUT_BEEP = JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
    private Class[] fValidTypes;
    private JavaEditor fEditor;

    FindAction(IWorkbenchSite site, String label, Class[] validTypes) {
        super(site);
        this.setText(label);
        this.fValidTypes = validTypes;
    }

    FindAction(JavaEditor editor, String label, Class[] validTypes) {
        this((IWorkbenchSite)editor.getEditorSite(), label, validTypes);
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    private boolean canOperateOn(IStructuredSelection sel) {
        return sel != null && !sel.isEmpty() && this.canOperateOn(this.getJavaElement(sel, true));
    }

    boolean canOperateOn(IJavaElement element) {
        if (this.fValidTypes == null || this.fValidTypes.length == 0) {
            return false;
        }
        if (element != null) {
            int i = 0;
            while (i < this.fValidTypes.length) {
                if (this.fValidTypes[i].isInstance(element)) {
                    if (element.getElementType() == 4) {
                        return this.hasChildren((IPackageFragment)element);
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean hasChildren(IPackageFragment packageFragment) {
        try {
            return packageFragment.hasChildren();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private IJavaElement getJavaElement(IJavaElement o, boolean silent) {
        if (o == null) {
            return null;
        }
        switch (o.getElementType()) {
            case 5: {
                if (silent) {
                    return (ICompilationUnit)o;
                }
                return this.findType((ICompilationUnit)o, silent);
            }
            case 6: {
                return this.findType((IClassFile)o);
            }
        }
        return o;
    }

    private IJavaElement getJavaElement(IMarker marker, boolean silent) {
        return this.getJavaElement(SearchUtil.getJavaElement(marker), silent);
    }

    private IJavaElement getJavaElement(Object o, boolean silent) {
        if (o instanceof IJavaElement) {
            return this.getJavaElement((IJavaElement)o, silent);
        }
        if (o instanceof IMarker) {
            return this.getJavaElement((IMarker)o, silent);
        }
        if (o instanceof ISelection) {
            return this.getJavaElement((IStructuredSelection)o, silent);
        }
        if (SearchUtil.isISearchResultViewEntry(o)) {
            return this.getJavaElement(SearchUtil.getJavaElement(o), silent);
        }
        return null;
    }

    IJavaElement getJavaElement(IStructuredSelection selection, boolean silent) {
        if (selection.size() == 1) {
            return this.getJavaElement(selection.getFirstElement(), silent);
        }
        return null;
    }

    private void showOperationUnavailableDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)SearchMessages.getString("JavaElementAction.operationUnavailable.title"), (String)this.getOperationUnavailableMessage());
    }

    String getOperationUnavailableMessage() {
        return SearchMessages.getString("JavaElementAction.operationUnavailable.generic");
    }

    private IJavaElement findType(ICompilationUnit cu, boolean silent) {
        Object[] types = null;
        try {
            types = cu.getAllTypes();
        }
        catch (JavaModelException ex) {
            ExceptionHandler.log(ex, SearchMessages.getString("JavaElementAction.error.open.message"));
            if (silent) {
                return RETURN_WITHOUT_BEEP;
            }
            return null;
        }
        if (types.length == 1 || silent && types.length > 0) {
            return types[0];
        }
        if (silent) {
            return RETURN_WITHOUT_BEEP;
        }
        if (types.length == 0) {
            return null;
        }
        String title = SearchMessages.getString("JavaElementAction.typeSelectionDialog.title");
        String message = SearchMessages.getString("JavaElementAction.typeSelectionDialog.message");
        int flags = JavaElementLabelProvider.SHOW_DEFAULT;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(types);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return RETURN_WITHOUT_BEEP;
    }

    private IType findType(IClassFile cf) {
        IType mainType;
        try {
            mainType = cf.getType();
        }
        catch (JavaModelException ex) {
            ExceptionHandler.log(ex, SearchMessages.getString("JavaElementAction.error.open.message"));
            return null;
        }
        return mainType;
    }

    protected void run(IStructuredSelection selection) {
        IJavaElement element = this.getJavaElement(selection, false);
        if (element == null || !element.exists()) {
            this.showOperationUnavailableDialog();
            return;
        }
        if (element == RETURN_WITHOUT_BEEP) {
            return;
        }
        this.run(element);
    }

    protected void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            String title = SearchMessages.getString("SearchElementSelectionDialog.title");
            String message = SearchMessages.getString("SearchElementSelectionDialog.message");
            IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
            if (elements.length > 0 && this.canOperateOn(elements[0])) {
                IJavaElement element = elements[0];
                if (elements.length > 1) {
                    element = SelectionConverter.codeResolve(this.fEditor, this.getShell(), title, message);
                }
                this.run(element);
            } else {
                this.showOperationUnavailableDialog();
            }
        }
        catch (JavaModelException ex) {
            JavaPlugin.log(ex);
            String title = SearchMessages.getString("Search.Error.search.title");
            String message = SearchMessages.getString("Search.Error.codeResolve");
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)ex.getStatus());
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canOperateOn(selection));
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    void run(IJavaElement element) {
        block17: {
            if (!ActionUtil.isProcessable(this.getShell(), element)) {
                return;
            }
            SearchUI.activateSearchResultView();
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            JavaSearchOperation op = null;
            try {
                op = this.makeOperation(element);
                if (op == null) {
                    return;
                }
            }
            catch (JavaModelException ex) {
                ExceptionHandler.handle((CoreException)((Object)ex), shell, SearchMessages.getString("Search.Error.search.title"), SearchMessages.getString("Search.Error.search.message"));
                return;
            }
            IWorkspaceDescription workspaceDesc = JavaPlugin.getWorkspace().getDescription();
            boolean isAutoBuilding = workspaceDesc.isAutoBuilding();
            if (isAutoBuilding) {
                workspaceDesc.setAutoBuilding(false);
                try {
                    JavaPlugin.getWorkspace().setDescription(workspaceDesc);
                }
                catch (CoreException ex) {
                    ExceptionHandler.handle(ex, shell, SearchMessages.getString("Search.Error.setDescription.title"), SearchMessages.getString("Search.Error.setDescription.message"));
                }
            }
            try {
                try {
                    new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)op);
                }
                catch (InvocationTargetException ex) {
                    ExceptionHandler.handle(ex, shell, SearchMessages.getString("Search.Error.search.title"), SearchMessages.getString("Search.Error.search.message"));
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (isAutoBuilding) {
                    workspaceDesc = JavaPlugin.getWorkspace().getDescription();
                    workspaceDesc.setAutoBuilding(true);
                    try {
                        JavaPlugin.getWorkspace().setDescription(workspaceDesc);
                    }
                    catch (CoreException ex) {
                        ExceptionHandler.handle(ex, shell, SearchMessages.getString("Search.Error.setDescription.title"), SearchMessages.getString("Search.Error.setDescription.message"));
                    }
                }
                throw throwable;
            }
            Object var7_11 = null;
            if (!isAutoBuilding) break block17;
            workspaceDesc = JavaPlugin.getWorkspace().getDescription();
            workspaceDesc.setAutoBuilding(true);
            try {
                JavaPlugin.getWorkspace().setDescription(workspaceDesc);
            }
            catch (CoreException ex) {
                ExceptionHandler.handle(ex, shell, SearchMessages.getString("Search.Error.setDescription.title"), SearchMessages.getString("Search.Error.setDescription.message"));
            }
        }
    }

    JavaSearchOperation makeOperation(IJavaElement element) throws JavaModelException {
        IType type = this.getType(element);
        return new JavaSearchOperation(JavaPlugin.getWorkspace(), element, this.getLimitTo(), this.getScope(type), this.getScopeDescription(type), this.getCollector());
    }

    abstract int getLimitTo();

    IJavaSearchScope getScope(IType element) throws JavaModelException {
        return SearchEngine.createWorkspaceScope();
    }

    JavaSearchResultCollector getCollector() {
        return new JavaSearchResultCollector();
    }

    String getScopeDescription(IType type) {
        return SearchMessages.getString("WorkspaceScope");
    }

    IType getType(IJavaElement element) {
        IType type = null;
        if (element.getElementType() == 7) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        if (type != null) {
            ICompilationUnit cu = type.getCompilationUnit();
            if (cu == null) {
                return type;
            }
            IType wcType = (IType)this.getWorkingCopy((IJavaElement)type);
            if (wcType != null) {
                return wcType;
            }
            return type;
        }
        return null;
    }

    private IJavaElement getWorkingCopy(IJavaElement input) {
        try {
            if (input instanceof ICompilationUnit) {
                return EditorUtility.getWorkingCopy((ICompilationUnit)input);
            }
            return EditorUtility.getWorkingCopy(input, true);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }
}

