/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractTempRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.ExtractTempWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExtractTempAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.getString("ExtractTempAction.extract_temp");

    public ExtractTempAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.getString("ExtractTempAction.label"));
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.extract_temp_action");
    }

    private Refactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) {
        return new ExtractTempRefactoring(cunit, selection.getOffset(), selection.getLength(), JavaPreferencesSettings.getCodeGenerationSettings());
    }

    private RefactoringWizard createWizard(Refactoring refactoring) {
        String helpId = "org.eclipse.jdt.ui.extract_temp_error_wizard_page_context";
        String pageTitle = RefactoringMessages.getString("ExtractTempAction.extract_temp");
        return new ExtractTempWizard((ExtractTempRefactoring)refactoring, pageTitle, helpId);
    }

    protected void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            Refactoring refactoring = this.createRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection);
            new RefactoringStarter().activate(refactoring, this.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }

    protected void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(ITextSelection selection) {
        if (selection.getLength() == 0) {
            return false;
        }
        return this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null;
    }
}

