/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.nls.ExternalizeWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExternalizeStringsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public ExternalizeStringsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("ExternalizeStringsAction.label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.externalize_strings_action");
    }

    public ExternalizeStringsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getCompilationUnit(selection) != null);
    }

    protected void run(ITextSelection selection) {
        IJavaElement element = SelectionConverter.getInput(this.fEditor);
        if (!(element instanceof ICompilationUnit)) {
            return;
        }
        this.run((ICompilationUnit)element);
    }

    protected void run(IStructuredSelection selection) {
        this.run(this.getCompilationUnit(selection));
    }

    private void run(ICompilationUnit unit) {
        if (!ActionUtil.isProcessable(this.getShell(), unit)) {
            return;
        }
        try {
            ExternalizeStringsAction.openExternalizeStringsWizard(unit);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), ExternalizeStringsAction.getDialogTitle(), ActionMessages.getString("ExternalizeStringsAction.dialog.message"));
        }
    }

    private ICompilationUnit getCompilationUnit(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof ICompilationUnit) {
            return (ICompilationUnit)first;
        }
        if (first instanceof IType) {
            return ((IType)first).getCompilationUnit();
        }
        return null;
    }

    private static Refactoring createNewRefactoringInstance(ICompilationUnit cu) {
        return new NLSRefactoring(cu, JavaPreferencesSettings.getCodeGenerationSettings());
    }

    static void openExternalizeStringsWizard(ICompilationUnit unit) throws JavaModelException {
        if (unit == null) {
            return;
        }
        Refactoring refactoring = ExternalizeStringsAction.createNewRefactoringInstance(unit);
        ExternalizeWizard wizard = new ExternalizeWizard(refactoring);
        new RefactoringStarter().activate(refactoring, wizard, JavaPlugin.getActiveWorkbenchShell(), ExternalizeStringsAction.getDialogTitle(), true);
    }

    private static String getDialogTitle() {
        return ActionMessages.getString("ExternalizeStringsAction.dialog.title");
    }
}

