/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindAction;
import org.eclipse.jdt.ui.actions.FindDeclarationsAction;
import org.eclipse.jdt.ui.actions.FindDeclarationsInHierarchyAction;
import org.eclipse.jdt.ui.actions.FindDeclarationsInWorkingSetAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.actions.WorkingSetFindAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;

public class DeclarationsSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.getString("group.declarations");
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindDeclarationsAction fFindDeclarationsAction;
    private FindDeclarationsInWorkingSetAction fFindDeclarationsInWorkingSetAction;
    private FindDeclarationsInHierarchyAction fFindDeclarationsInHierarchyAction;

    public DeclarationsSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fFindDeclarationsAction = new FindDeclarationsAction(site);
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(site);
        this.fFindDeclarationsInHierarchyAction = new FindDeclarationsInHierarchyAction(site);
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fFindDeclarationsAction, provider, selection);
        this.registerAction(this.fFindDeclarationsInHierarchyAction, provider, selection);
        this.registerAction(this.fFindDeclarationsInWorkingSetAction, provider, selection);
    }

    public DeclarationsSearchGroup(JavaEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindDeclarationsAction = new FindDeclarationsAction(this.fEditor);
        this.fFindDeclarationsAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.declarations.in.workspace");
        this.fEditor.setAction("SearchDeclarationsInWorkspace", (IAction)this.fFindDeclarationsAction);
        this.fFindDeclarationsInHierarchyAction = new FindDeclarationsInHierarchyAction(this.fEditor);
        this.fFindDeclarationsInHierarchyAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.declarations.in.hierarchy");
        this.fEditor.setAction("SearchDeclarationsInHierarchy", (IAction)this.fFindDeclarationsInHierarchyAction);
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(this.fEditor);
        this.fFindDeclarationsInWorkingSetAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.declarations.in.working.set");
        this.fEditor.setAction("SearchDeclarationsInWorkingSet", (IAction)this.fFindDeclarationsInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    private FindAction[] getActions(ISelection sel) {
        ArrayList<FindAction> actions = new ArrayList<FindAction>(SearchUtil.LRU_WORKINGSET_LIST_SIZE + 3);
        actions.add(this.fFindDeclarationsAction);
        actions.add(this.fFindDeclarationsInHierarchyAction);
        actions.add(this.fFindDeclarationsInWorkingSetAction);
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            IWorkingSet[] workingSets = (IWorkingSet[])iter.next();
            WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindDeclarationsInWorkingSetAction(this.fEditor, workingSets), SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindDeclarationsInWorkingSetAction(this.fSite, workingSets), SearchUtil.toString(workingSets));
            action.update(sel);
            actions.add(action);
        }
        return actions.toArray(new FindAction[actions.size()]);
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(MENU_TEXT, "group.search");
        ISelection sel = this.getContext().getSelection();
        FindAction[] actions = this.getActions(sel);
        int i = 0;
        while (i < actions.length) {
            FindAction action = actions[i];
            if (action.isEnabled()) {
                javaSearchMM.add((IAction)action);
            }
            ++i;
        }
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindDeclarationsAction, provider);
            this.disposeAction(this.fFindDeclarationsInHierarchyAction, provider);
            this.disposeAction(this.fFindDeclarationsInWorkingSetAction, provider);
        }
        this.fFindDeclarationsAction = null;
        this.fFindDeclarationsInHierarchyAction = null;
        this.fFindDeclarationsInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.DeclarationsInWorkspace", (IAction)this.fFindDeclarationsAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.DeclarationsInHierarchy", (IAction)this.fFindDeclarationsInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.DeclarationsInWorkingSet", (IAction)this.fFindDeclarationsInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

