/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.filters.CustomFiltersDialog;
import org.eclipse.jdt.internal.ui.filters.FilterDescriptor;
import org.eclipse.jdt.internal.ui.filters.FilterMessages;
import org.eclipse.jdt.internal.ui.filters.NamePatternFilter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionGroup;

public class CustomFiltersActionGroup
extends ActionGroup {
    private static final String TAG_CUSTOM_FILTERS = "customFilters";
    private static final String TAG_USER_DEFINED_PATTERNS_ENABLED = "userDefinedPatternsEnabled";
    private static final String TAG_USER_DEFINED_PATTERNS = "userDefinedPatterns";
    private static final String TAG_XML_DEFINED_FILTERS = "xmlDefinedFilters";
    private static final String TAG_CHILD = "child";
    private static final String TAG_PATTERN = "pattern";
    private static final String TAG_FILTER_ID = "filterId";
    private static final String TAG_IS_ENABLED = "isEnabled";
    private static final String SEPARATOR = ",";
    private IViewPart fPart;
    private StructuredViewer fViewer;
    private NamePatternFilter fPatternFilter;
    private Map fInstalledBuiltInFilters;
    private Map fEnabledFilterIds;
    private boolean fUserDefinedPatternsEnabled;
    private String[] fUserDefinedPatterns;

    public CustomFiltersActionGroup(IViewPart part, StructuredViewer viewer) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)viewer);
        this.fPart = part;
        this.fViewer = viewer;
        this.initializeWithPluginContributions();
        this.initializeWithViewDefaults();
        this.installFilters();
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    private String[] getEnabledFilterIds() {
        HashSet<String> enabledFilterIds = new HashSet<String>(this.fEnabledFilterIds.size());
        Iterator iter = this.fEnabledFilterIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String id = (String)entry.getKey();
            boolean isEnabled = (Boolean)entry.getValue();
            if (!isEnabled) continue;
            enabledFilterIds.add(id);
        }
        return enabledFilterIds.toArray(new String[enabledFilterIds.size()]);
    }

    private void setEnabledFilterIds(String[] enabledIds) {
        Iterator iter = this.fEnabledFilterIds.keySet().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            this.fEnabledFilterIds.put(id, Boolean.FALSE);
        }
        int i = 0;
        while (i < enabledIds.length) {
            this.fEnabledFilterIds.put(enabledIds[i], Boolean.TRUE);
            ++i;
        }
    }

    private void setUserDefinedPatterns(String[] patterns) {
        this.fUserDefinedPatterns = patterns;
        this.cleanUpPatternDuplicates();
    }

    private boolean areUserDefinedPatternsEnabled() {
        return this.fUserDefinedPatternsEnabled;
    }

    private void setUserDefinedPatternsEnabled(boolean state) {
        this.fUserDefinedPatternsEnabled = state;
    }

    private void fillToolBar(IToolBarManager tooBar) {
    }

    private void fillViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator("filters"));
        viewMenu.add((IAction)new ShowFilterDialogAction());
    }

    public void dispose() {
        super.dispose();
    }

    private void initializeWithPluginContributions() {
        this.fUserDefinedPatterns = new String[0];
        this.fUserDefinedPatternsEnabled = false;
        String viewId = this.fPart.getViewSite().getId();
        FilterDescriptor[] filterDescs = FilterDescriptor.getFilterDescriptors(viewId);
        this.fEnabledFilterIds = new HashMap(filterDescs.length);
        int i = 0;
        while (i < filterDescs.length) {
            String id = filterDescs[i].getId();
            Boolean isEnabled = new Boolean(filterDescs[i].isEnabled());
            if (this.fEnabledFilterIds.containsKey(id)) {
                JavaPlugin.logErrorMessage("WARNING: Duplicate id for extension-point \"org.eclipse.jdt.ui.javaElementFilters\"");
            }
            this.fEnabledFilterIds.put(id, isEnabled);
            ++i;
        }
    }

    private void installFilters() {
        this.fInstalledBuiltInFilters = new HashMap(this.fEnabledFilterIds.size());
        this.fPatternFilter = new NamePatternFilter();
        this.fPatternFilter.setPatterns(this.getUserAndBuiltInPatterns());
        this.fViewer.addFilter((ViewerFilter)this.fPatternFilter);
        this.updateBuiltInFilters();
    }

    private void updateViewerFilters(boolean refresh) {
        String[] patterns = this.getUserAndBuiltInPatterns();
        this.fPatternFilter.setPatterns(patterns);
        this.fViewer.getControl().setRedraw(false);
        this.updateBuiltInFilters();
        if (refresh) {
            this.fViewer.refresh();
        }
        this.fViewer.getControl().setRedraw(true);
    }

    private void updateBuiltInFilters() {
        Set installedFilters = this.fInstalledBuiltInFilters.keySet();
        HashSet<String> filtersToAdd = new HashSet<String>(this.fEnabledFilterIds.size());
        HashSet<String> filtersToRemove = new HashSet<String>(this.fEnabledFilterIds.size());
        Iterator iter = this.fEnabledFilterIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String id = (String)entry.getKey();
            boolean isEnabled = (Boolean)entry.getValue();
            if (isEnabled && !installedFilters.contains(id)) {
                filtersToAdd.add(id);
                continue;
            }
            if (isEnabled || !installedFilters.contains(id)) continue;
            filtersToRemove.add(id);
        }
        String viewId = this.fPart.getViewSite().getId();
        FilterDescriptor[] filterDescs = FilterDescriptor.getFilterDescriptors(viewId);
        int i = 0;
        while (i < filterDescs.length) {
            String id = filterDescs[i].getId();
            boolean isCustomFilter = filterDescs[i].isCustomFilter();
            if (isCustomFilter) {
                ViewerFilter filter;
                if (filtersToAdd.contains(id) && (filter = filterDescs[i].createViewerFilter()) != null) {
                    this.fViewer.addFilter(filter);
                    this.fInstalledBuiltInFilters.put(id, filter);
                }
                if (filtersToRemove.contains(id)) {
                    this.fViewer.removeFilter((ViewerFilter)this.fInstalledBuiltInFilters.get(id));
                    this.fInstalledBuiltInFilters.remove(id);
                }
            }
            ++i;
        }
    }

    private String[] getUserAndBuiltInPatterns() {
        String viewId = this.fPart.getViewSite().getId();
        ArrayList<String> patterns = new ArrayList<String>(this.fUserDefinedPatterns.length);
        if (this.areUserDefinedPatternsEnabled()) {
            patterns.addAll(Arrays.asList(this.fUserDefinedPatterns));
        }
        FilterDescriptor[] filterDescs = FilterDescriptor.getFilterDescriptors(viewId);
        int i = 0;
        while (i < filterDescs.length) {
            String id = filterDescs[i].getId();
            boolean isPatternFilter = filterDescs[i].isPatternFilter();
            Object isEnabled = this.fEnabledFilterIds.get(id);
            if (isEnabled != null && isPatternFilter && ((Boolean)isEnabled).booleanValue()) {
                patterns.add(filterDescs[i].getPattern());
            }
            ++i;
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private void initializeWithViewDefaults() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        if (!store.contains(this.getPreferenceKey("TAG_DUMMY_TO_TEST_EXISTENCE"))) {
            return;
        }
        this.fUserDefinedPatternsEnabled = store.getBoolean(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS_ENABLED));
        this.setUserDefinedPatterns(CustomFiltersDialog.convertFromString(store.getString(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS)), SEPARATOR));
        Iterator iter = this.fEnabledFilterIds.keySet().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            Boolean isEnabled = new Boolean(store.getBoolean(id));
            this.fEnabledFilterIds.put(id, isEnabled);
        }
    }

    private void storeViewDefaults() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        store.setValue(this.getPreferenceKey("TAG_DUMMY_TO_TEST_EXISTENCE"), "storedViewPreferences");
        store.setValue(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS_ENABLED), this.fUserDefinedPatternsEnabled);
        store.setValue(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS), CustomFiltersDialog.convertToString(this.fUserDefinedPatterns, SEPARATOR));
        Iterator iter = this.fEnabledFilterIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String id = (String)entry.getKey();
            boolean isEnabled = (Boolean)entry.getValue();
            store.setValue(id, isEnabled);
        }
    }

    private String getPreferenceKey(String tag) {
        return "CustomFiltersActionGroup." + this.fPart.getViewSite().getId() + '.' + tag;
    }

    public void saveState(IMemento memento) {
        IMemento customFilters = memento.createChild(TAG_CUSTOM_FILTERS);
        customFilters.putString(TAG_USER_DEFINED_PATTERNS_ENABLED, new Boolean(this.fUserDefinedPatternsEnabled).toString());
        this.saveUserDefinedPatterns(customFilters);
        this.saveXmlDefinedPatterns(customFilters);
    }

    private void saveXmlDefinedPatterns(IMemento memento) {
        if (this.fEnabledFilterIds != null && !this.fEnabledFilterIds.isEmpty()) {
            IMemento xmlDefinedFilters = memento.createChild(TAG_XML_DEFINED_FILTERS);
            Iterator iter = this.fEnabledFilterIds.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String id = (String)entry.getKey();
                Boolean isEnabled = (Boolean)entry.getValue();
                IMemento child = xmlDefinedFilters.createChild(TAG_CHILD);
                child.putString(TAG_FILTER_ID, id);
                child.putString(TAG_IS_ENABLED, isEnabled.toString());
            }
        }
    }

    private void saveUserDefinedPatterns(IMemento memento) {
        if (this.fUserDefinedPatterns != null && this.fUserDefinedPatterns.length > 0) {
            IMemento userDefinedPatterns = memento.createChild(TAG_USER_DEFINED_PATTERNS);
            int i = 0;
            while (i < this.fUserDefinedPatterns.length) {
                IMemento child = userDefinedPatterns.createChild(TAG_CHILD);
                child.putString(TAG_PATTERN, this.fUserDefinedPatterns[i]);
                ++i;
            }
        }
    }

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento customFilters = memento.getChild(TAG_CUSTOM_FILTERS);
        if (customFilters == null) {
            return;
        }
        String userDefinedPatternsEnabled = customFilters.getString(TAG_USER_DEFINED_PATTERNS_ENABLED);
        if (userDefinedPatternsEnabled == null) {
            return;
        }
        this.fUserDefinedPatternsEnabled = Boolean.valueOf(userDefinedPatternsEnabled);
        this.restoreUserDefinedPatterns(customFilters);
        this.restoreXmlDefinedFilters(customFilters);
        this.updateViewerFilters(false);
    }

    private void restoreUserDefinedPatterns(IMemento memento) {
        IMemento userDefinedPatterns = memento.getChild(TAG_USER_DEFINED_PATTERNS);
        if (userDefinedPatterns != null) {
            IMemento[] children = userDefinedPatterns.getChildren(TAG_CHILD);
            String[] patterns = new String[children.length];
            int i = 0;
            while (i < children.length) {
                patterns[i] = children[i].getString(TAG_PATTERN);
                ++i;
            }
            this.setUserDefinedPatterns(patterns);
        } else {
            this.setUserDefinedPatterns(new String[0]);
        }
    }

    private void restoreXmlDefinedFilters(IMemento memento) {
        IMemento xmlDefinedPatterns = memento.getChild(TAG_XML_DEFINED_FILTERS);
        if (xmlDefinedPatterns != null) {
            IMemento[] children = xmlDefinedPatterns.getChildren(TAG_CHILD);
            int i = 0;
            while (i < children.length) {
                String id = children[i].getString(TAG_FILTER_ID);
                Boolean isEnabled = new Boolean(children[i].getString(TAG_IS_ENABLED));
                this.fEnabledFilterIds.put(id, isEnabled);
                ++i;
            }
        }
    }

    private void cleanUpPatternDuplicates() {
        if (!this.areUserDefinedPatternsEnabled()) {
            return;
        }
        ArrayList<String> userDefinedPatterns = new ArrayList<String>(Arrays.asList(this.fUserDefinedPatterns));
        FilterDescriptor[] filters = FilterDescriptor.getFilterDescriptors(this.fPart.getViewSite().getId());
        int i = 0;
        while (i < filters.length) {
            String pattern;
            if (filters[i].isPatternFilter() && userDefinedPatterns.contains(pattern = filters[i].getPattern())) {
                this.fEnabledFilterIds.put(filters[i].getId(), Boolean.TRUE);
                boolean hasMore = true;
                while (hasMore) {
                    hasMore = userDefinedPatterns.remove(pattern);
                }
            }
            ++i;
        }
        this.fUserDefinedPatterns = userDefinedPatterns.toArray(new String[userDefinedPatterns.size()]);
        this.setUserDefinedPatternsEnabled(this.fUserDefinedPatternsEnabled && this.fUserDefinedPatterns.length > 0);
    }

    private void openDialog() {
        CustomFiltersDialog dialog = new CustomFiltersDialog(this.fPart.getViewSite().getShell(), this.fPart.getViewSite().getId(), this.areUserDefinedPatternsEnabled(), this.fUserDefinedPatterns, this.getEnabledFilterIds());
        if (dialog.open() == 0) {
            this.setEnabledFilterIds(dialog.getEnabledFilterIds());
            this.setUserDefinedPatternsEnabled(dialog.areUserDefinedPatternsEnabled());
            this.setUserDefinedPatterns(dialog.getUserDefinedPatterns());
            this.storeViewDefaults();
            this.updateViewerFilters(true);
        }
    }

    class ShowFilterDialogAction
    extends Action {
        ShowFilterDialogAction() {
            this.setText(FilterMessages.getString("OpenCustomFiltersDialogAction.text"));
            this.setImageDescriptor(JavaPluginImages.DESC_CLCL_FILTER);
        }

        public void run() {
            CustomFiltersActionGroup.this.openDialog();
        }
    }
}

