/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.ui.actions.RefreshAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.BuildAction;

public class BuildActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private BuildAction fBuildAction;
    private BuildAction fFullBuildAction;
    private RefreshAction fRefreshAction;

    public BuildActionGroup(IViewPart part) {
        this.fSite = part.getSite();
        Shell shell = this.fSite.getShell();
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        this.fBuildAction = new BuildAction(shell, 10);
        this.fBuildAction.setText(ActionMessages.getString("BuildAction.label"));
        this.fFullBuildAction = new BuildAction(shell, 6);
        this.fFullBuildAction.setText(ActionMessages.getString("RebuildAction.label"));
        this.fRefreshAction = new RefreshAction(this.fSite);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fBuildAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fFullBuildAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fRefreshAction);
    }

    public IAction getRefreshAction() {
        return this.fRefreshAction;
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelection selection = this.getContext().getSelection();
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding() && this.isBuildTarget(selection)) {
            this.appendToGroup(menu, (IAction)this.fBuildAction);
        }
        this.appendToGroup(menu, (IAction)this.fRefreshAction);
        super.fillContextMenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fBuildAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fFullBuildAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fRefreshAction);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
        actionBar.setGlobalActionHandler("buildProject", (IAction)this.fBuildAction);
        actionBar.setGlobalActionHandler("rebuildProject", (IAction)this.fFullBuildAction);
        actionBar.setGlobalActionHandler("refresh", (IAction)this.fRefreshAction);
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.build", action);
        }
    }

    private boolean isBuildTarget(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IJavaProject;
    }
}

