/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.codemanipulation.AddJavaDocStubOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddJavaDocStubAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public AddJavaDocStubAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("AddJavaDocStubAction.label"));
        this.setDescription(ActionMessages.getString("AddJavaDocStubAction.description"));
        this.setToolTipText(ActionMessages.getString("AddJavaDocStubAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.add_javadoc_stub_action");
    }

    public AddJavaDocStubAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    protected void selectionChanged(IStructuredSelection selection) {
        IMember[] members = this.getSelectedMembers(selection);
        this.setEnabled(members != null && members.length > 0);
    }

    protected void run(IStructuredSelection selection) {
        IMember[] members = this.getSelectedMembers(selection);
        if (members == null || members.length == 0) {
            return;
        }
        try {
            IMember[] workingCopyMembers;
            ICompilationUnit workingCopyCU;
            ICompilationUnit cu = members[0].getCompilationUnit();
            if (!ActionUtil.isProcessable(this.getShell(), cu)) {
                return;
            }
            IEditorPart editor = EditorUtility.openInEditor(cu);
            if (cu.isWorkingCopy()) {
                workingCopyCU = cu;
                workingCopyMembers = members;
                ICompilationUnit iCompilationUnit = workingCopyCU;
                synchronized (iCompilationUnit) {
                    workingCopyCU.reconcile();
                }
            } else {
                workingCopyCU = EditorUtility.getWorkingCopy(cu);
                if (workingCopyCU == null) {
                    this.showError(ActionMessages.getString("AddJavaDocStubsAction.error.noWorkingCopy"));
                    return;
                }
                workingCopyMembers = new IMember[members.length];
                int i = 0;
                while (i < members.length) {
                    IMember member = members[i];
                    IMember workingCopyMember = JavaModelUtil.findMemberInCompilationUnit(workingCopyCU, member);
                    if (workingCopyMember == null) {
                        this.showError(ActionMessages.getFormattedString("AddJavaDocStubsAction.error.memberNotExisting", member.getElementName()));
                        return;
                    }
                    workingCopyMembers[i] = workingCopyMember;
                    ++i;
                }
            }
            if (ElementValidator.check((IJavaElement[])workingCopyMembers, this.getShell(), this.getDialogTitle(), false)) {
                this.run(workingCopyMembers);
            }
            ICompilationUnit iCompilationUnit = workingCopyCU;
            synchronized (iCompilationUnit) {
                workingCopyCU.reconcile();
            }
            EditorUtility.revealInEditor(editor, (IJavaElement)members[0]);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.getString("AddJavaDocStubsAction.error.actionFailed"));
        }
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    protected void run(ITextSelection selection) {
        try {
            int type;
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (!ActionUtil.isProcessable(this.getShell(), element)) {
                return;
            }
            int n = type = element != null ? element.getElementType() : -1;
            if (type != 9 && type != 7 && (element = SelectionConverter.getTypeAtOffset(this.fEditor)) == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.getString("AddJavaDocStubsAction.not_applicable"));
                return;
            }
            IMember[] members = new IMember[]{(IMember)element};
            if (ElementValidator.checkValidateEdit((IJavaElement[])members, this.getShell(), this.getDialogTitle())) {
                this.run(members);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.getString("AddJavaDocStubsAction.error.actionFailed"));
        }
    }

    private void run(IMember[] members) {
        try {
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
            AddJavaDocStubOperation op = new AddJavaDocStubOperation(members, settings);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            dialog.run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.getString("AddJavaDocStubsAction.error.actionFailed"));
        }
        catch (InterruptedException interruptedException) {}
    }

    private void showError(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)message);
    }

    private IMember[] getSelectedMembers(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IMember[] res = new IMember[nElements];
            ICompilationUnit cu = null;
            int i = 0;
            while (i < nElements) {
                IMember member;
                Object curr = elements.get(i);
                if (curr instanceof IMethod || curr instanceof IType || curr instanceof IField) {
                    member = (IMember)curr;
                    if (i == 0 ? (cu = member.getCompilationUnit()) == null : !cu.equals(member.getCompilationUnit())) {
                        return null;
                    }
                } else {
                    return null;
                }
                res[i] = member;
                ++i;
            }
            return res;
        }
        return null;
    }

    private String getDialogTitle() {
        return ActionMessages.getString("AddJavaDocStubsAction.error.dialogTitle");
    }
}

