/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.AddGetterSetterOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddGetterSetterAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String dialogTitle = ActionMessages.getString("AddGetterSetterAction.error.title");
    static /* synthetic */ Class class$0;

    public AddGetterSetterAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("AddGetterSetterAction.label"));
        this.setDescription(ActionMessages.getString("AddGetterSetterAction.description"));
        this.setToolTipText(ActionMessages.getString("AddGetterSetterAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.getter_setter_action_context");
    }

    public AddGetterSetterAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(editor) != null);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    protected void run(IStructuredSelection selection) {
        try {
            IField[] selectedFields = this.getSelectedFields(selection);
            if (AddGetterSetterAction.canEnableOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                this.run(((ICompilationUnit)firstElement).findPrimaryType(), new IField[0], false);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), dialogTitle, ActionMessages.getString("AddGetterSetterAction.error.actionfailed"));
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (AddGetterSetterAction.canEnableOn(this.getSelectedFields(selection))) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            return AddGetterSetterAction.canEnableOn((IType)selection.getFirstElement());
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit) {
            return AddGetterSetterAction.canEnableOn(((ICompilationUnit)selection.getFirstElement()).findPrimaryType());
        }
        return false;
    }

    private static boolean canEnableOn(IType type) throws JavaModelException {
        if (type == null) {
            return false;
        }
        if (type.getFields().length == 0) {
            return false;
        }
        return type.getCompilationUnit() != null;
    }

    private static boolean canEnableOn(IField[] fields) throws JavaModelException {
        return fields != null && fields.length > 0;
    }

    private void run(IType type, IField[] preselected, boolean editor) throws CoreException {
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), dialogTitle, editor)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), type)) {
            return;
        }
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        AddGetterSetterLabelProvider lp = new AddGetterSetterLabelProvider();
        Map entries = AddGetterSetterAction.createGetterSetterMapping(type, settings);
        if (entries.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)dialogTitle, (String)ActionMessages.getString("AddGettSetterAction.typeContainsNoFields.message"));
            return;
        }
        AddGetterSetterContentProvider cp = new AddGetterSetterContentProvider(entries);
        CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(dialogTitle);
        String message = ActionMessages.getString("AddGetterSetterAction.dialog.title");
        dialog.setMessage(message);
        dialog.setValidator(AddGetterSetterAction.createValidator());
        dialog.setContainerMode(true);
        dialog.setSize(60, 18);
        dialog.setInput((Object)type);
        dialog.setExpandedElements((Object[])type.getFields());
        dialog.setInitialSelections((Object[])preselected);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null) {
            return;
        }
        IField[] getterFields = AddGetterSetterAction.getGetterFields(result);
        IField[] setterFields = AddGetterSetterAction.getSetterFields(result);
        this.generate(getterFields, setterFields);
    }

    private static ISelectionStatusValidator createValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                int count = this.countSelectedMethods(selection);
                if (count == 0) {
                    return new StatusInfo(4, "");
                }
                if (count == 1) {
                    return new StatusInfo(1, ActionMessages.getString("AddGetterSetterAction.one_selected"));
                }
                String message = ActionMessages.getFormattedString("AddGetterSetterAction.methods_selected", String.valueOf(count));
                return new StatusInfo(1, message);
            }

            private int countSelectedMethods(Object[] selection) {
                int count = 0;
                int i = 0;
                while (i < selection.length) {
                    if (selection[i] instanceof GetterSetterEntry) {
                        ++count;
                    }
                    ++i;
                }
                return count;
            }
        };
    }

    private static IField[] getGetterFields(Object[] result) {
        ArrayList<IField> list = new ArrayList<IField>(0);
        int i = 0;
        while (i < result.length) {
            Object each = result[i];
            if (each instanceof GetterSetterEntry) {
                GetterSetterEntry entry = (GetterSetterEntry)each;
                if (entry.isGetterEntry) {
                    list.add(entry.field);
                }
            }
            ++i;
        }
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getSetterFields(Object[] result) {
        ArrayList<IField> list = new ArrayList<IField>(0);
        int i = 0;
        while (i < result.length) {
            Object each = result[i];
            if (each instanceof GetterSetterEntry) {
                GetterSetterEntry entry = (GetterSetterEntry)each;
                if (!entry.isGetterEntry) {
                    list.add(entry.field);
                }
            }
            ++i;
        }
        return list.toArray(new IField[list.size()]);
    }

    private void generate(IField[] getterFields, IField[] setterFields) throws CoreException {
        if (getterFields.length == 0 && setterFields.length == 0) {
            return;
        }
        ICompilationUnit cu = null;
        cu = getterFields.length != 0 ? getterFields[0].getCompilationUnit() : setterFields[0].getCompilationUnit();
        IEditorPart editor = EditorUtility.openInEditor(cu);
        IField[] workingCopyGetterFields = this.getWorkingCopyFields(getterFields);
        IField[] workingCopySetterFields = this.getWorkingCopyFields(setterFields);
        if (workingCopyGetterFields != null && workingCopySetterFields != null) {
            this.run(workingCopyGetterFields, workingCopySetterFields, editor);
        }
    }

    private IField[] getWorkingCopyFields(IField[] fields) throws CoreException {
        IField[] workingCopyFields;
        if (fields.length == 0) {
            return new IField[0];
        }
        ICompilationUnit cu = fields[0].getCompilationUnit();
        if (cu.isWorkingCopy()) {
            ICompilationUnit workingCopyCU = cu;
            workingCopyFields = fields;
        } else {
            ICompilationUnit workingCopyCU = EditorUtility.getWorkingCopy(cu);
            if (workingCopyCU == null) {
                this.showError(ActionMessages.getString("AddGetterSetterAction.error.actionfailed"));
                return null;
            }
            workingCopyFields = new IField[fields.length];
            int i = 0;
            while (i < fields.length) {
                IField field = fields[i];
                IField workingCopyField = (IField)JavaModelUtil.findMemberInCompilationUnit(workingCopyCU, (IMember)field);
                if (workingCopyField == null) {
                    this.showError(ActionMessages.getFormattedString("AddGetterSetterAction.error.fieldNotExisting", field.getElementName()));
                    return null;
                }
                workingCopyFields[i] = workingCopyField;
                ++i;
            }
        }
        return workingCopyFields;
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    protected void run(ITextSelection selection) {
        try {
            IType type;
            IJavaElement input = SelectionConverter.getInput(this.fEditor);
            if (!ActionUtil.isProcessable(this.getShell(), input)) {
                return;
            }
            IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, true);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null && type.getFields().length > 0) {
                this.run(type, new IField[0], true);
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)dialogTitle, (String)ActionMessages.getString("AddGetterSetterAction.not_applicable"));
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), dialogTitle, ActionMessages.getString("AddGetterSetterAction.error.actionfailed"));
        }
    }

    private void run(IField[] getterFields, IField[] setterFields, IEditorPart editor) {
        block13: {
            IRewriteTarget target;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (IRewriteTarget)editor.getAdapter((Class)clazz)) != null) {
                target.beginCompoundChange();
            }
            try {
                try {
                    AddGetterSetterOperation op = this.createAddGetterSetterOperation(getterFields, setterFields);
                    new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op));
                    IMethod[] createdMethods = op.getCreatedAccessors();
                    if (createdMethods.length > 0) {
                        EditorUtility.revealInEditor(editor, (IJavaElement)createdMethods[0]);
                    }
                }
                catch (InvocationTargetException e) {
                    String message = ActionMessages.getString("AddGetterSetterAction.error.actionfailed");
                    ExceptionHandler.handle(e, this.getShell(), dialogTitle, message);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (target != null) {
                    target.endCompoundChange();
                }
                throw throwable;
            }
            Object var7_11 = null;
            if (target == null) break block13;
            target.endCompoundChange();
        }
    }

    private AddGetterSetterOperation createAddGetterSetterOperation(IField[] getterFields, IField[] setterFields) {
        IRequestQuery skipSetterForFinalQuery = this.skipSetterForFinalQuery();
        IRequestQuery skipReplaceQuery = this.skipReplaceQuery();
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        return new AddGetterSetterOperation(getterFields, setterFields, settings, skipSetterForFinalQuery, skipReplaceQuery);
    }

    private IRequestQuery skipSetterForFinalQuery() {
        return new IRequestQuery(){

            public int doQuery(IMember field) {
                int[] nArray = new int[4];
                nArray[0] = 2;
                nArray[1] = 3;
                nArray[2] = 1;
                int[] returnCodes = nArray;
                String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                String fieldName = JavaElementLabels.getElementLabel((IJavaElement)field, 0);
                String formattedMessage = ActionMessages.getFormattedString("AddGetterSetterAction.SkipSetterForFinalDialog.message", fieldName);
                return AddGetterSetterAction.this.showQueryDialog(formattedMessage, options, returnCodes);
            }
        };
    }

    private IRequestQuery skipReplaceQuery() {
        return new IRequestQuery(){

            public int doQuery(IMember method) {
                int[] nArray = new int[4];
                nArray[0] = 2;
                nArray[1] = 1;
                nArray[2] = 3;
                int[] returnCodes = nArray;
                String skipLabel = ActionMessages.getString("AddGetterSetterAction.SkipExistingDialog.skip.label");
                String replaceLabel = ActionMessages.getString("AddGetterSetterAction.SkipExistingDialog.replace.label");
                String skipAllLabel = ActionMessages.getString("AddGetterSetterAction.SkipExistingDialog.skipAll.label");
                String[] options = new String[]{skipLabel, replaceLabel, skipAllLabel, IDialogConstants.CANCEL_LABEL};
                String methodName = JavaElementLabels.getElementLabel((IJavaElement)method, 1);
                String formattedMessage = ActionMessages.getFormattedString("AddGetterSetterAction.SkipExistingDialog.message", methodName);
                return AddGetterSetterAction.this.showQueryDialog(formattedMessage, options, returnCodes);
            }
        };
    }

    private int showQueryDialog(final String message, final String[] buttonLabels, int[] returnCodes) {
        final Shell shell = this.getShell();
        if (shell == null) {
            JavaPlugin.logErrorMessage("AddGetterSetterAction.showQueryDialog: No active shell found");
            return 0;
        }
        final int[] result = new int[]{1};
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = ActionMessages.getString("AddGetterSetterAction.QueryDialog.title");
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, buttonLabels, 0);
                result[0] = dialog.open();
            }
        });
        int returnVal = result[0];
        return returnVal < 0 ? 0 : returnCodes[returnVal];
    }

    private void showError(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)message);
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IField[] res = new IField[nElements];
            ICompilationUnit cu = null;
            int i = 0;
            while (i < nElements) {
                IField fld;
                block7: {
                    Object curr = elements.get(i);
                    if (curr instanceof IField) {
                        fld = (IField)curr;
                        if (i == 0 ? (cu = fld.getCompilationUnit()) == null : !cu.equals(fld.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            if (fld.getDeclaringType().isInterface()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log(e);
                            return null;
                        }
                    }
                    return null;
                }
                res[i] = fld;
                ++i;
            }
            return res;
        }
        return null;
    }

    private static Map createGetterSetterMapping(IType type, CodeGenerationSettings settings) throws JavaModelException {
        IField[] fields = type.getFields();
        HashMap<IField, GetterSetterEntry[]> result = new HashMap<IField, GetterSetterEntry[]>();
        int i = 0;
        while (i < fields.length) {
            ArrayList<GetterSetterEntry> l = new ArrayList<GetterSetterEntry>(2);
            if (GetterSetterUtil.getGetter(fields[i]) == null) {
                l.add(new GetterSetterEntry(fields[i], true));
            }
            if (GetterSetterUtil.getSetter(fields[i]) == null) {
                l.add(new GetterSetterEntry(fields[i], false));
            }
            if (!l.isEmpty()) {
                result.put(fields[i], l.toArray(new GetterSetterEntry[l.size()]));
            }
            ++i;
        }
        return result;
    }

    private static class GetterSetterEntry {
        public final IField field;
        public final boolean isGetterEntry;

        GetterSetterEntry(IField field, boolean isGetterEntry) {
            this.field = field;
            this.isGetterEntry = isGetterEntry;
        }
    }

    private static class AddGetterSetterLabelProvider
    extends JavaElementLabelProvider {
        AddGetterSetterLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof GetterSetterEntry) {
                GetterSetterEntry entry = (GetterSetterEntry)element;
                try {
                    if (entry.isGetterEntry) {
                        return String.valueOf(GetterSetterUtil.getGetterName(entry.field, null)) + "()";
                    }
                    return String.valueOf(GetterSetterUtil.getSetterName(entry.field, null)) + '(' + Signature.getSimpleName((String)Signature.toString((String)entry.field.getTypeSignature())) + ')';
                }
                catch (JavaModelException javaModelException) {
                    return "";
                }
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof GetterSetterEntry) {
                int flags = 0;
                try {
                    flags = ((GetterSetterEntry)element).field.getFlags();
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
                Object desc = JavaElementImageProvider.getFieldImageDescriptor(false, 1);
                int adornmentFlags = Flags.isStatic((int)flags) ? 8 : 0;
                desc = new JavaElementImageDescriptor((ImageDescriptor)desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
            return super.getImage(element);
        }
    }

    private static class AddGetterSetterContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private Map fGetterSetterEntries;

        public AddGetterSetterContentProvider(Map entries) throws JavaModelException {
            this.fGetterSetterEntries = entries;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IField) {
                return (Object[])this.fGetterSetterEntries.get(parentElement);
            }
            return EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof IMember) {
                return ((IMember)element).getDeclaringType();
            }
            if (element instanceof GetterSetterEntry) {
                return ((GetterSetterEntry)element).field;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fGetterSetterEntries.keySet().toArray();
        }

        public void dispose() {
            this.fGetterSetterEntries.clear();
            this.fGetterSetterEntries = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

