/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddDelegateMethodsAction
extends SelectionDispatchAction {
    private static final String DIALOG_TITLE = ActionMessages.getString("AddDelegateMethodsAction.error.title");
    private CompilationUnitEditor fEditor;
    static /* synthetic */ Class class$0;

    public AddDelegateMethodsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("AddDelegateMethodsAction.label"));
        this.setDescription(ActionMessages.getString("AddDelegateMethodsAction.description"));
        this.setToolTipText(ActionMessages.getString("AddDelegateMethodsAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.add_delegate_methods_action");
    }

    public AddDelegateMethodsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(editor) != null);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    protected void run(IStructuredSelection selection) {
        try {
            IField[] selectedFields = this.getSelectedFields(selection);
            if (AddDelegateMethodsAction.canEnableOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                this.run(JavaElementUtil.getMainType((ICompilationUnit)firstElement), new IField[0], false);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.getString("AddDelegateMethodsAction.error.actionfailed"));
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (AddDelegateMethodsAction.canEnableOn(this.getSelectedFields(selection))) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            return AddDelegateMethodsAction.canEnableOn((IType)selection.getFirstElement());
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit) {
            return AddDelegateMethodsAction.canEnableOn(JavaElementUtil.getMainType((ICompilationUnit)selection.getFirstElement()));
        }
        return false;
    }

    private static boolean canEnableOn(IType type) throws JavaModelException {
        if (type == null || type.getCompilationUnit() == null) {
            return false;
        }
        return AddDelegateMethodsAction.canEnableOn(type.getFields());
    }

    private static boolean canEnableOn(IField[] fields) throws JavaModelException {
        if (fields == null) {
            return false;
        }
        int count = 0;
        int i = 0;
        while (i < fields.length) {
            if (!AddDelegateMethodsAction.hasPrimitiveType(fields[i]) || AddDelegateMethodsAction.isArray(fields[i])) {
                ++count;
            }
            ++i;
        }
        return count > 0;
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IField[] res = new IField[nElements];
            ICompilationUnit cu = null;
            int i = 0;
            while (i < nElements) {
                IField fld;
                block7: {
                    Object curr = elements.get(i);
                    if (curr instanceof IField) {
                        fld = (IField)curr;
                        if (i == 0 ? (cu = fld.getCompilationUnit()) == null : !cu.equals(fld.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            if (fld.getDeclaringType().isInterface()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log(e);
                            return null;
                        }
                    }
                    return null;
                }
                res[i] = fld;
                ++i;
            }
            return res;
        }
        return null;
    }

    private void run(IType type, IField[] preselected, boolean editor) throws CoreException {
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), DIALOG_TITLE, editor)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), type)) {
            return;
        }
        if (!AddDelegateMethodsAction.canEnableOn(type)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.getString("AddDelegateMethodsAction.not_applicable"));
            return;
        }
        this.showUI(type, preselected);
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    protected void run(ITextSelection selection) {
        try {
            IType type;
            IJavaElement input = SelectionConverter.getInput(this.fEditor);
            if (!ActionUtil.isProcessable(this.getShell(), input)) {
                return;
            }
            IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, true);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null && type.getFields().length > 0) {
                this.run(type, new IField[0], true);
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.getString("AddDelegateMethodsAction.not_applicable"));
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.getString("AddDelegateMethodsAction.error.actionfailed"));
        }
    }

    private void showUI(IType type, IField[] preselected) {
        block15: {
            try {
                FieldContentProvider provider = new FieldContentProvider(type);
                Methods2FieldLabelProvider methodLabel = new Methods2FieldLabelProvider();
                CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(this.getShell(), (ILabelProvider)methodLabel, (ITreeContentProvider)provider);
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        StatusInfo state = new StatusInfo();
                        if (selection != null && selection.length > 0) {
                            HashSet<Object> map = new HashSet<Object>(selection.length);
                            int count = 0;
                            int i = 0;
                            while (i < selection.length) {
                                Object key = selection[i];
                                if (selection[i] instanceof Methods2Field) {
                                    ++count;
                                    try {
                                        key = AddDelegateMethodsAction.createSignatureKey(((Methods2Field)selection[i]).fMethod);
                                    }
                                    catch (JavaModelException e) {
                                        return new StatusInfo(4, e.toString());
                                    }
                                }
                                if (!map.add(key)) {
                                    state = new StatusInfo(4, ActionMessages.getString("AddDelegateMethodsAction.duplicate_methods"));
                                    break;
                                }
                                String message = count == 1 ? ActionMessages.getFormattedString("AddDelegateMethodsAction.selectioninfo.one", String.valueOf(count)) : ActionMessages.getFormattedString("AddDelegateMethodsAction.selectioninfo.more", String.valueOf(count));
                                state = new StatusInfo(1, message);
                                ++i;
                            }
                        }
                        return state;
                    }
                });
                dialog.setSorter((ViewerSorter)new Methods2FieldSorter());
                dialog.setInput((Object)provider);
                dialog.setContainerMode(true);
                dialog.setMessage(ActionMessages.getString("AddDelegateMethodsAction.message"));
                dialog.setTitle(ActionMessages.getString("AddDelegateMethodsAction.title"));
                dialog.setExpandedElements((Object[])preselected);
                int result = dialog.open();
                if (result != 0) break block15;
                Object[] o = dialog.getResult();
                if (o == null) {
                    return;
                }
                ArrayList<Object> methods = new ArrayList<Object>(o.length);
                int i = 0;
                while (i < o.length) {
                    if (o[i] instanceof Methods2Field) {
                        methods.add(o[i]);
                    }
                    ++i;
                }
                IEditorPart part = EditorUtility.openInEditor(type);
                type = (IType)JavaModelUtil.toWorkingCopy((IMember)type);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IRewriteTarget target = (IRewriteTarget)part.getAdapter((Class)clazz);
                IMethod[] createdMethods = null;
                try {
                    if (target != null) {
                        target.beginCompoundChange();
                    }
                    createdMethods = this.processResults(methods, type);
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (target != null) {
                        target.endCompoundChange();
                    }
                    throw throwable;
                }
                Object var12_17 = null;
                if (target != null) {
                    target.endCompoundChange();
                }
                if (createdMethods != null && createdMethods.length > 0) {
                    type.getCompilationUnit().reconcile();
                    EditorUtility.revealInEditor(part, (IJavaElement)createdMethods[0]);
                }
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, DIALOG_TITLE, ActionMessages.getString("AddDelegateMethodsAction.error.actionfailed"));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, DIALOG_TITLE, ActionMessages.getString("AddDelegateMethodsAction.error.actionfailed"));
            }
        }
    }

    private IMethod[] processResults(List list, IType type) throws InvocationTargetException {
        if (list.size() == 0) {
            return null;
        }
        ResultRunner resultRunner = new ResultRunner(list, type);
        ProgressMonitorDialog runnableContext = new ProgressMonitorDialog(this.getShell());
        try {
            runnableContext.run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(resultRunner));
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return resultRunner.getCreatedMethods();
    }

    private static IMethod[] resolveMethodsHierarchy(IType type) throws JavaModelException {
        HashMap map = new HashMap();
        IType[] superTypes = JavaModelUtil.getAllSuperTypes(type, (IProgressMonitor)new NullProgressMonitor());
        AddDelegateMethodsAction.addMethodsToMapping(map, type);
        int i = 0;
        while (i < superTypes.length) {
            AddDelegateMethodsAction.addMethodsToMapping(map, superTypes[i]);
            ++i;
        }
        return map.values().toArray(new IMethod[map.values().size()]);
    }

    private static void addMethodsToMapping(Map map, IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            map.put(AddDelegateMethodsAction.createSignatureKey(methods[i]), methods[i]);
            ++i;
        }
    }

    private static IMethod[] resolveFinalMethods(IType type) throws JavaModelException {
        if (type.isInterface()) {
            type = AddDelegateMethodsAction.getJavaLangObject(type.getJavaProject());
        }
        IMethod[] methods = AddDelegateMethodsAction.resolveMethodsHierarchy(type);
        ArrayList<IMethod> list = new ArrayList<IMethod>(methods.length);
        int i = 0;
        while (i < methods.length) {
            boolean isFinal = Flags.isFinal((int)methods[i].getFlags());
            if (isFinal) {
                list.add(methods[i]);
            }
            ++i;
        }
        return list.toArray(new IMethod[list.size()]);
    }

    private static String createSignatureKey(IMethod method) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(method.getElementName());
        String[] args = method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            String signature;
            if (AddDelegateMethodsAction.isUnresolved(args[i])) {
                int acount = Signature.getArrayCount((String)args[i]);
                if (acount > 0) {
                    String arg = args[i];
                    int index = arg.lastIndexOf(91);
                    arg = arg.substring(index + 1);
                    signature = Signature.toString((String)arg);
                } else {
                    signature = Signature.toString((String)args[i]);
                }
                String[][] fqn = method.getDeclaringType().resolveType(signature);
                if (fqn != null) {
                    buffer.append(fqn[0][0]).append('.').append(fqn[0][1]);
                    int j = 0;
                    while (j < acount) {
                        buffer.append("[]");
                        ++j;
                    }
                }
            } else {
                signature = Signature.toString((String)args[i]);
                buffer.append(signature);
            }
            ++i;
        }
        return buffer.toString();
    }

    private static boolean isUnresolved(String signature) {
        boolean primitive;
        boolean flag = false;
        char c = Signature.getElementType((String)signature).charAt(0);
        boolean bl = primitive = c != 'L' && c != 'Q';
        if (primitive) {
            return flag;
        }
        int acount = Signature.getArrayCount((String)signature);
        if (acount > 0) {
            int index = signature.lastIndexOf(91);
            c = signature.charAt(index + 1);
        } else {
            c = signature.charAt(0);
        }
        switch (c) {
            case 'L': {
                flag = false;
                break;
            }
            case 'Q': {
                flag = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return flag;
    }

    private static boolean hasPrimitiveType(IField field) throws JavaModelException {
        String signature = field.getTypeSignature();
        char first = Signature.getElementType((String)signature).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private static IType resolveTypeOfField(IField field) throws JavaModelException {
        boolean isPrimitive = AddDelegateMethodsAction.hasPrimitiveType(field);
        boolean isArray = AddDelegateMethodsAction.isArray(field);
        if (!isPrimitive && !isArray) {
            String typeName = JavaModelUtil.getResolvedTypeName(field.getTypeSignature(), field.getDeclaringType());
            return typeName != null ? field.getJavaProject().findType(typeName) : null;
        }
        if (isArray) {
            return AddDelegateMethodsAction.getJavaLangObject(field.getJavaProject());
        }
        return null;
    }

    private static IType getJavaLangObject(IJavaProject project) throws JavaModelException {
        return JavaModelUtil.findType(project, "java.lang.Object");
    }

    private static boolean isArray(IField field) throws JavaModelException {
        return Signature.getArrayCount((String)field.getTypeSignature()) > 0;
    }

    private static class ResultRunner
    implements IWorkspaceRunnable {
        List fList = null;
        IType fType = null;
        List fCreatedMethods;

        public ResultRunner(List resultList, IType type) {
            this.fList = resultList;
            this.fType = type;
            this.fCreatedMethods = new ArrayList();
        }

        public IMethod[] getCreatedMethods() {
            return this.fCreatedMethods.toArray(new IMethod[this.fCreatedMethods.size()]);
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            String message = ActionMessages.getFormattedString("AddDelegateMethodsAction.monitor.message", String.valueOf(this.fList.size()));
            monitor.setTaskName(message);
            monitor.beginTask("", this.fList.size());
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
            boolean addComments = settings.createComments;
            IMethod[] existingMethods = this.fType.getMethods();
            String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)this.fType);
            int indent = StubUtility.getIndentUsed((IJavaElement)this.fType) + 1;
            ImportsStructure imports = new ImportsStructure(this.fType.getCompilationUnit(), settings.importOrder, settings.importThreshold, true);
            int i = 0;
            while (i < this.fList.size()) {
                if (monitor.isCanceled()) {
                    if (i > 0) {
                        imports.create(false, null);
                    }
                    return;
                }
                ITypeHierarchy typeHierarchy = this.fType.newSupertypeHierarchy(null);
                String content = null;
                Methods2Field wrapper = (Methods2Field)this.fList.get(i);
                IMethod curr = wrapper.fMethod;
                IField field = wrapper.fField;
                monitor.subTask(JavaElementLabels.getElementLabel((IJavaElement)curr, 1));
                IMethod overwrittenMethod = JavaModelUtil.findMethodImplementationInHierarchy(typeHierarchy, this.fType, curr.getElementName(), curr.getParameterTypes(), curr.isConstructor());
                if (overwrittenMethod == null) {
                    content = this.createStub(field, curr, addComments, overwrittenMethod, imports);
                } else {
                    IMethod declaration = JavaModelUtil.findMethodDeclarationInHierarchy(typeHierarchy, this.fType, curr.getElementName(), curr.getParameterTypes(), curr.isConstructor());
                    content = this.createStub(field, declaration, addComments, overwrittenMethod, imports);
                }
                IMethod sibling = null;
                IMethod existing = JavaModelUtil.findMethod(curr.getElementName(), curr.getParameterTypes(), curr.isConstructor(), existingMethods);
                if (existing == null) {
                    if (curr.isConstructor() && existingMethods.length > 0) {
                        sibling = existingMethods[0];
                    }
                    String formattedContent = String.valueOf(StubUtility.codeFormat(content, indent, lineDelim)) + lineDelim;
                    IMethod created = this.fType.createMethod(formattedContent, (IJavaElement)sibling, true, null);
                    this.fCreatedMethods.add(created);
                    monitor.worked(1);
                }
                ++i;
            }
            imports.create(false, null);
        }

        private String createStub(IField field, IMethod curr, boolean addComment, IMethod overridden, IImportsStructure imports) throws CoreException {
            String comment;
            String methodName = curr.getElementName();
            String[] paramNames = curr.getParameterNames();
            String returnTypSig = curr.getReturnType();
            StringBuffer buf = new StringBuffer();
            if (addComment && (comment = CodeGeneration.getMethodComment(this.fType.getCompilationUnit(), this.fType.getElementName(), methodName, paramNames, curr.getExceptionTypes(), returnTypSig, overridden, String.valueOf('\n'))) != null) {
                buf.append(comment);
            }
            String methodDeclaration = null;
            if (this.fType.isClass()) {
                StringBuffer body = new StringBuffer();
                if (!"V".equals(returnTypSig)) {
                    body.append("return ");
                }
                if (JdtFlags.isStatic((IMember)curr)) {
                    body.append(AddDelegateMethodsAction.resolveTypeOfField(field).getElementName());
                } else {
                    body.append(field.getElementName());
                }
                body.append('.').append(methodName).append('(');
                int i = 0;
                while (i < paramNames.length) {
                    body.append(paramNames[i]);
                    if (i < paramNames.length - 1) {
                        body.append(',');
                    }
                    ++i;
                }
                body.append(");");
                methodDeclaration = body.toString();
            }
            StubUtility.genMethodDeclaration(this.fType.getElementName(), curr, methodDeclaration, imports, buf);
            return buf.toString();
        }
    }

    private static class FieldContentProvider
    implements ITreeContentProvider {
        private Map fTreeMap = null;
        private Map fFieldMap = null;
        private Map fFilter = new HashMap();

        FieldContentProvider(IType type) throws JavaModelException {
            this.fTreeMap = new TreeMap();
            this.fFieldMap = new HashMap();
            this.buildModel(type);
        }

        private void buildModel(IType type) throws JavaModelException {
            IField[] fields = type.getFields();
            IMethod[] finMeths = AddDelegateMethodsAction.resolveFinalMethods(type);
            int i = 0;
            while (i < finMeths.length) {
                this.fFilter.put(AddDelegateMethodsAction.createSignatureKey(finMeths[i]), finMeths[i]);
                ++i;
            }
            IMethod[] filter = type.getMethods();
            int i2 = 0;
            while (i2 < filter.length) {
                this.fFilter.put(AddDelegateMethodsAction.createSignatureKey(filter[i2]), filter[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < fields.length) {
                IType fieldType = AddDelegateMethodsAction.resolveTypeOfField(fields[i2]);
                if (fieldType != null) {
                    IMethod[] methods = AddDelegateMethodsAction.resolveMethodsHierarchy(fieldType);
                    ArrayList<Methods2Field> accessMethods = new ArrayList<Methods2Field>();
                    int j = 0;
                    while (j < methods.length) {
                        boolean finalExist;
                        boolean publicField = JdtFlags.isPublic((IMember)methods[j]);
                        boolean constructor = methods[j].isConstructor();
                        boolean bl = finalExist = this.fFilter.get(AddDelegateMethodsAction.createSignatureKey(methods[j])) != null;
                        if (publicField && !constructor && !finalExist) {
                            accessMethods.add(new Methods2Field(methods[j], fields[i2]));
                        }
                        ++j;
                    }
                    Object[] m = accessMethods.toArray();
                    Methods2Field[] mf = new Methods2Field[m.length];
                    int j2 = 0;
                    while (j2 < m.length) {
                        mf[j2] = (Methods2Field)m[j2];
                        ++j2;
                    }
                    this.fTreeMap.put(fields[i2].getElementName(), mf);
                    this.fFieldMap.put(fields[i2].getElementName(), fields[i2]);
                }
                ++i2;
            }
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IField) {
                return (Object[])this.fTreeMap.get(((IField)parentElement).getElementName());
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IField;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof FieldContentProvider) {
                Object[] o = this.fTreeMap.keySet().toArray();
                Object[] fields = new Object[o.length];
                int i = 0;
                while (i < o.length) {
                    fields[i] = this.fFieldMap.get(o[i]);
                    ++i;
                }
                return fields;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class Methods2Field {
        IMethod fMethod = null;
        IField fField = null;

        public Methods2Field(IMethod method, IField field) {
            this.fMethod = method;
            this.fField = field;
        }
    }

    private static class Methods2FieldLabelProvider
    implements ILabelProvider {
        JavaElementLabelProvider fMethodLabel = new JavaElementLabelProvider();

        public Methods2FieldLabelProvider() {
            this.fMethodLabel.turnOn(32);
        }

        public Image getImage(Object element) {
            if (element instanceof Methods2Field) {
                Methods2Field wrapper = (Methods2Field)element;
                return this.fMethodLabel.getImage(wrapper.fMethod);
            }
            if (element instanceof IJavaElement) {
                return this.fMethodLabel.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Methods2Field) {
                Methods2Field wrapper = (Methods2Field)element;
                return this.fMethodLabel.getText(wrapper.fMethod);
            }
            if (element instanceof IJavaElement) {
                return this.fMethodLabel.getText(element);
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
            this.fMethodLabel.addListener(listener);
        }

        public void dispose() {
            this.fMethodLabel.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.fMethodLabel.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.fMethodLabel.removeListener(listener);
        }
    }

    private static class Methods2FieldSorter
    extends ViewerSorter {
        JavaElementSorter fSorter = new JavaElementSorter();

        Methods2FieldSorter() {
        }

        public int category(Object element) {
            if (element instanceof Methods2Field) {
                element = ((Methods2Field)element).fMethod;
            }
            return this.fSorter.category(element);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Methods2Field) {
                e1 = ((Methods2Field)e1).fMethod;
            }
            if (e2 instanceof Methods2Field) {
                e2 = ((Methods2Field)e2).fMethod;
            }
            return this.fSorter.compare(viewer, e1, e2);
        }

        public Collator getCollator() {
            return this.fSorter.getCollator();
        }
    }
}

