/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.SharedImages;
import org.eclipse.jdt.internal.ui.dialogs.MainTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.MultiMainTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.MultiTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;

public final class JavaUI {
    private static ISharedImages fgSharedImages = null;
    public static final String ID_PLUGIN = "org.eclipse.jdt.ui";
    public static final String ID_PERSPECTIVE = "org.eclipse.jdt.ui.JavaPerspective";
    public static final String ID_HIERARCHYPERSPECTIVE = "org.eclipse.jdt.ui.JavaHierarchyPerspective";
    public static final String ID_ACTION_SET = "org.eclipse.jdt.ui.JavaActionSet";
    public static final String ID_ELEMENT_CREATION_ACTION_SET = "org.eclipse.jdt.ui.JavaElementCreationActionSet";
    public static final String ID_CODING_ACTION_SET = "org.eclipse.jdt.ui.CodingActionSet";
    public static final String ID_OPEN_ACTION_SET = "org.eclipse.jdt.ui.A_OpenActionSet";
    public static final String ID_SEARCH_ACTION_SET = "org.eclipse.jdt.ui.SearchActionSet";
    public static final String ID_CU_EDITOR = "org.eclipse.jdt.ui.CompilationUnitEditor";
    public static final String ID_CF_EDITOR = "org.eclipse.jdt.ui.ClassFileEditor";
    public static final String ID_SNIPPET_EDITOR = "org.eclipse.jdt.ui.SnippetEditor";
    public static final String ID_PACKAGES = "org.eclipse.jdt.ui.PackageExplorer";
    public static final String ID_TYPE_HIERARCHY = "org.eclipse.jdt.ui.TypeHierarchy";
    public static String ID_BROWSING_PERSPECTIVE = "org.eclipse.jdt.ui.JavaBrowsingPerspective";
    public static String ID_PROJECTS_VIEW = "org.eclipse.jdt.ui.ProjectsView";
    public static String ID_PACKAGES_VIEW = "org.eclipse.jdt.ui.PackagesView";
    public static String ID_TYPES_VIEW = "org.eclipse.jdt.ui.TypesView";
    public static String ID_MEMBERS_VIEW = "org.eclipse.jdt.ui.MembersView";
    public static final String ATTR_CMDLINE = "org.eclipse.jdt.ui.launcher.cmdLine";

    private JavaUI() {
    }

    public static ISharedImages getSharedImages() {
        if (fgSharedImages == null) {
            fgSharedImages = new SharedImages();
        }
        return fgSharedImages;
    }

    public static SelectionDialog createPackageDialog(Shell parent, IJavaProject project, int style, String filter) throws JavaModelException {
        Assert.isTrue(((style | 8 | 0x20) == 40 ? 1 : 0) != 0);
        IPackageFragmentRoot[] roots = null;
        roots = (style & 0x20) != 0 ? project.getAllPackageFragmentRoots() : project.getPackageFragmentRoots();
        List<IPackageFragmentRoot> consideredRoots = null;
        if ((style & 8) != 0) {
            consideredRoots = Arrays.asList(roots);
        } else {
            consideredRoots = new ArrayList<IPackageFragmentRoot>(roots.length);
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (root.getKind() != 2) {
                    consideredRoots.add(root);
                }
                ++i;
            }
        }
        int flags = JavaElementLabelProvider.SHOW_DEFAULT;
        if (consideredRoots.size() > 1) {
            flags |= 0x40;
        }
        ArrayList<IJavaElement> packages = new ArrayList<IJavaElement>();
        Iterator<IPackageFragmentRoot> iter = consideredRoots.iterator();
        while (iter.hasNext()) {
            IPackageFragmentRoot root = iter.next();
            packages.addAll(Arrays.asList(root.getChildren()));
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(parent, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setIgnoreCase(false);
        dialog.setElements(packages.toArray());
        dialog.setFilter(filter);
        return dialog;
    }

    public static SelectionDialog createPackageDialog(Shell parent, IJavaProject project, int style) throws JavaModelException {
        return JavaUI.createPackageDialog(parent, project, style, "");
    }

    public static SelectionDialog createPackageDialog(Shell parent, IPackageFragmentRoot root, String filter) throws JavaModelException {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(parent, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setElements((Object[])root.getChildren());
        dialog.setFilter(filter);
        return dialog;
    }

    public static SelectionDialog createPackageDialog(Shell parent, IPackageFragmentRoot root) throws JavaModelException {
        return JavaUI.createPackageDialog(parent, root, "");
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, int style, boolean multipleSelection, String filter) throws JavaModelException {
        int elementKinds = 0;
        if (style == 6) {
            elementKinds = 0;
        } else if (style == 4) {
            elementKinds = 6;
        } else if (style == 2) {
            elementKinds = 5;
        } else {
            Assert.isTrue((boolean)false, (String)"illegal style");
        }
        if (multipleSelection) {
            MultiTypeSelectionDialog dialog = new MultiTypeSelectionDialog(parent, context, elementKinds, scope);
            dialog.setMessage(JavaUIMessages.getString("JavaUI.defaultDialogMessage"));
            dialog.setFilter(filter);
            return dialog;
        }
        TypeSelectionDialog dialog = new TypeSelectionDialog(parent, context, elementKinds, scope);
        dialog.setMessage(JavaUIMessages.getString("JavaUI.defaultDialogMessage"));
        dialog.setFilter(filter);
        return dialog;
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, int style, boolean multipleSelection) throws JavaModelException {
        return JavaUI.createTypeDialog(parent, context, scope, style, multipleSelection, "");
    }

    public static SelectionDialog createMainTypeDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, int style, boolean multipleSelection, String filter) {
        if (multipleSelection) {
            MultiMainTypeSelectionDialog dialog = new MultiMainTypeSelectionDialog(parent, context, scope, style);
            dialog.setFilter(filter);
            return dialog;
        }
        MainTypeSelectionDialog dialog = new MainTypeSelectionDialog(parent, context, scope, style);
        dialog.setFilter(filter);
        return dialog;
    }

    public static SelectionDialog createMainTypeDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, int style, boolean multipleSelection) {
        return JavaUI.createMainTypeDialog(parent, context, scope, style, multipleSelection, "");
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IProject project, int style, boolean multipleSelection) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{JavaCore.create((IProject)project)});
        return JavaUI.createTypeDialog(parent, context, scope, style, multipleSelection);
    }

    public static IEditorPart openInEditor(IJavaElement element) throws JavaModelException, PartInitException {
        return EditorUtility.openInEditor(element);
    }

    public static void revealInEditor(IEditorPart part, ISourceReference element) {
        if (element instanceof IJavaElement) {
            JavaUI.revealInEditor(part, (IJavaElement)element);
        }
    }

    public static void revealInEditor(IEditorPart part, IJavaElement element) {
        EditorUtility.revealInEditor(part, element);
    }

    public static IWorkingCopyManager getWorkingCopyManager() {
        return JavaPlugin.getDefault().getWorkingCopyManager();
    }

    public static IWorkingCopy[] getSharedWorkingCopies() {
        return JavaCore.getSharedWorkingCopies((IBufferFactory)JavaUI.getBufferFactory());
    }

    public static IWorkingCopy[] getSharedWorkingCopiesOnClasspath() {
        IWorkingCopy[] wcs = JavaUI.getSharedWorkingCopies();
        ArrayList<IWorkingCopy> result = new ArrayList<IWorkingCopy>(wcs.length);
        int i = 0;
        while (i < wcs.length) {
            IJavaElement je;
            IWorkingCopy wc = wcs[i];
            if (wc instanceof IJavaElement && (je = (IJavaElement)wc).getJavaProject().isOnClasspath(je)) {
                result.add(wc);
            }
            ++i;
        }
        return result.toArray(new IWorkingCopy[result.size()]);
    }

    public static IBufferFactory getBufferFactory() {
        CompilationUnitDocumentProvider provider = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        if (provider != null) {
            return provider.getBufferFactory();
        }
        return null;
    }

    public static IDocumentProvider getDocumentProvider() {
        return JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
    }

    public static void setLibraryJavadocLocation(IPath archivePath, URL url) {
        JavaDocLocations.setLibraryJavadocLocation(archivePath, url);
    }

    public static URL getLibraryJavadocLocation(IPath archivePath) {
        return JavaDocLocations.getLibraryJavadocLocation(archivePath);
    }

    public static void setProjectJavadocLocation(IJavaProject project, URL url) {
        JavaDocLocations.setProjectJavadocLocation(project, url);
    }

    public static URL getProjectJavadocLocation(IJavaProject project) {
        return JavaDocLocations.getProjectJavadocLocation(project);
    }

    public static URL getJavadocBaseLocation(IJavaElement element) throws JavaModelException {
        return JavaDocLocations.getJavadocBaseLocation(element);
    }

    public static URL getJavadocLocation(IJavaElement element, boolean includeAnchor) throws JavaModelException {
        return JavaDocLocations.getJavadocLocation(element, includeAnchor);
    }
}

