/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.search.WorkingSetComparator;
import org.eclipse.jdt.internal.ui.workingsets.ClearWorkingSetAction;
import org.eclipse.jdt.internal.ui.workingsets.EditWorkingSetAction;
import org.eclipse.jdt.internal.ui.workingsets.SelectWorkingSetAction;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilter;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMenuContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;

public class WorkingSetFilterActionGroup
extends ActionGroup {
    private static final String TAG_WORKING_SET_NAME = "workingSetName";
    private static final String SEPARATOR_ID = "workingSetGroupSeparator";
    private StructuredViewer fViewer;
    private WorkingSetFilter fWorkingSetFilter;
    private IWorkingSet fWorkingSet = null;
    private ClearWorkingSetAction fClearWorkingSetAction;
    private SelectWorkingSetAction fSelectWorkingSetAction;
    private EditWorkingSetAction fEditWorkingSetAction;
    private IPropertyChangeListener fPropertyChangeListener;
    private IPropertyChangeListener fTitleUpdater;
    private int fLRUMenuCount;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;

    public WorkingSetFilterActionGroup(StructuredViewer viewer, String viewId, Shell shell, IPropertyChangeListener titleUpdater) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)viewId);
        Assert.isNotNull((Object)shell);
        this.fViewer = viewer;
        this.fTitleUpdater = titleUpdater;
        this.fClearWorkingSetAction = new ClearWorkingSetAction(this);
        this.fSelectWorkingSetAction = new SelectWorkingSetAction(this, shell);
        this.fEditWorkingSetAction = new EditWorkingSetAction(this, shell);
        this.fPropertyChangeListener = this.addWorkingSetChangeSupport();
    }

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet, boolean refreshViewer) {
        this.fClearWorkingSetAction.setEnabled(workingSet != null);
        this.fEditWorkingSetAction.setEnabled(workingSet != null);
        this.fWorkingSet = workingSet;
        if (this.fWorkingSetFilter != null) {
            this.fWorkingSetFilter.setWorkingSet(workingSet);
            if (refreshViewer) {
                this.fViewer.getControl().setRedraw(false);
                this.fViewer.refresh();
                this.fViewer.getControl().setRedraw(true);
            }
            if (this.fTitleUpdater != null) {
                this.fTitleUpdater.propertyChange(new PropertyChangeEvent((Object)this, "workingSetNameChange", null, (Object)workingSet));
            }
        }
    }

    public void saveState(IMemento memento) {
        String workingSetName = "";
        if (this.fWorkingSet != null) {
            workingSetName = this.fWorkingSet.getName();
        }
        memento.putString(TAG_WORKING_SET_NAME, workingSetName);
    }

    public void restoreState(IMemento memento) {
        String workingSetName = memento.getString(TAG_WORKING_SET_NAME);
        IWorkingSet ws = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName);
        this.setWorkingSet(ws, false);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.contributeToToolBar(actionBars.getToolBarManager());
        this.contributeToMenu(actionBars.getMenuManager());
    }

    public void contributeToToolBar(IToolBarManager tbm) {
    }

    public void contributeToMenu(IMenuManager mm) {
        mm.add((IAction)this.fSelectWorkingSetAction);
        mm.add((IAction)this.fClearWorkingSetAction);
        mm.add((IAction)this.fEditWorkingSetAction);
        mm.add((IContributionItem)new Separator());
        mm.add((IContributionItem)new Separator(SEPARATOR_ID));
        this.addLRUWorkingSetActions(mm);
        this.fMenuManager = mm;
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WorkingSetFilterActionGroup.this.removePreviousLRUWorkingSetActions(manager);
                WorkingSetFilterActionGroup.this.addLRUWorkingSetActions(manager);
            }
        };
        this.fMenuManager.addMenuListener(this.fMenuListener);
    }

    private void removePreviousLRUWorkingSetActions(IMenuManager mm) {
        int i = 1;
        while (i <= this.fLRUMenuCount) {
            mm.remove(WorkingSetMenuContributionItem.getId(i));
            ++i;
        }
    }

    private void addLRUWorkingSetActions(IMenuManager mm) {
        IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        List<IWorkingSet> sortedWorkingSets = Arrays.asList(workingSets);
        Collections.sort(sortedWorkingSets, new WorkingSetComparator());
        Iterator<IWorkingSet> iter = sortedWorkingSets.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IWorkingSet workingSet = iter.next();
            if (workingSet == null) continue;
            WorkingSetMenuContributionItem item = new WorkingSetMenuContributionItem(++i, this, workingSet);
            mm.insertBefore(SEPARATOR_ID, (IContributionItem)item);
        }
        this.fLRUMenuCount = i;
    }

    public void dispose() {
        if (this.fMenuManager != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
        }
        super.dispose();
    }

    private IPropertyChangeListener addWorkingSetChangeSupport() {
        final IPropertyChangeListener propertyChangeListener = this.createWorkingSetChangeListener();
        this.fWorkingSetFilter = new WorkingSetFilter();
        this.fViewer.addFilter((ViewerFilter)this.fWorkingSetFilter);
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(propertyChangeListener);
        this.fViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(propertyChangeListener);
            }
        });
        return propertyChangeListener;
    }

    private IPropertyChangeListener createWorkingSetChangeListener() {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("workingSetReplace".equals(property)) {
                    IWorkingSet newWorkingSet = (IWorkingSet)event.getNewValue();
                    WorkingSetFilterActionGroup.this.fWorkingSetFilter.setWorkingSet(newWorkingSet);
                    WorkingSetFilterActionGroup.this.fViewer.getControl().setRedraw(false);
                    WorkingSetFilterActionGroup.this.fViewer.refresh();
                    if (WorkingSetFilterActionGroup.this.fTitleUpdater != null) {
                        WorkingSetFilterActionGroup.this.fTitleUpdater.propertyChange(new PropertyChangeEvent((Object)this, "workingSetNameChange", null, (Object)newWorkingSet));
                    }
                    WorkingSetFilterActionGroup.this.fViewer.getControl().setRedraw(true);
                } else if ("workingSetNameChange".equals(property)) {
                    if (WorkingSetFilterActionGroup.this.fTitleUpdater != null) {
                        WorkingSetFilterActionGroup.this.fTitleUpdater.propertyChange(event);
                    }
                } else if ("workingSetContentChange".equals(property)) {
                    WorkingSetFilterActionGroup.this.fViewer.getControl().setRedraw(false);
                    WorkingSetFilterActionGroup.this.fViewer.refresh();
                    WorkingSetFilterActionGroup.this.fViewer.getControl().setRedraw(true);
                }
            }
        };
    }
}

