/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class SourceAttachmentDialog
extends StatusDialog {
    private SourceAttachmentBlock fSourceAttachmentBlock;
    private boolean fApplyChanges;

    public SourceAttachmentDialog(Shell parent, IClasspathEntry entry, IPath containerPath, IJavaProject project, boolean applyChanges) {
        super(parent);
        this.fApplyChanges = applyChanges;
        IStatusChangeListener listener = new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                SourceAttachmentDialog.this.updateStatus(status);
            }
        };
        this.fSourceAttachmentBlock = new SourceAttachmentBlock(listener, entry, containerPath, project);
        this.setTitle(NewWizardMessages.getString("SourceAttachmentDialog.title"));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.source_attachment_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Control inner = this.createSourceAttachmentControls(composite);
        inner.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createSourceAttachmentControls(Composite composite) {
        return this.fSourceAttachmentBlock.createControl(composite);
    }

    public IPath getSourceAttachmentPath() {
        return this.fSourceAttachmentBlock.getSourceAttachmentPath();
    }

    public IPath getSourceAttachmentRootPath() {
        return this.fSourceAttachmentBlock.getSourceAttachmentRootPath();
    }

    protected void okPressed() {
        super.okPressed();
        if (this.fApplyChanges) {
            try {
                IRunnableWithProgress runnable = this.getRunnable();
                new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                String title = NewWizardMessages.getString("SourceAttachmentDialog.error.title");
                String message = NewWizardMessages.getString("SourceAttachmentDialog.error.message");
                ExceptionHandler.handle(e, this.getShell(), title, message);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected IRunnableWithProgress getRunnable() {
        return this.fSourceAttachmentBlock.getRunnable(this.getShell());
    }

    public static IClasspathEntry getClasspathEntryToEdit(IJavaProject jproject, IPath containerPath, IPath libPath) throws JavaModelException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        if (container != null && initializer != null && initializer.canUpdateClasspathContainer(containerPath, jproject)) {
            IClasspathEntry[] entries = container.getClasspathEntries();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry curr = entries[i];
                IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)curr);
                if (resolved != null && libPath.equals((Object)resolved.getPath())) {
                    return curr;
                }
                ++i;
            }
        }
        return null;
    }
}

