/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.JARFileSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.VariablePathDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class EditVariableEntryDialog
extends StatusDialog {
    private IPath fFileVariablePath;
    private IStatus fNameStatus;
    private List fExistingEntries;
    private VariablePathDialogField fFileNameField;
    private CLabel fFullPathResolvedLabel;
    private IPath fEditEntry;

    public EditVariableEntryDialog(Shell parent, IPath editEntry, List existingEntries) {
        super(parent);
        this.fExistingEntries = existingEntries;
        this.fExistingEntries.remove(editEntry);
        this.fEditEntry = editEntry;
        SourceAttachmentAdapter adapter = new SourceAttachmentAdapter();
        this.fFileNameField = new VariablePathDialogField(adapter);
        this.fFileNameField.setDialogFieldListener(adapter);
        this.fFileNameField.setLabelText(NewWizardMessages.getString("EditVariableEntryDialog.filename.varlabel"));
        this.fFileNameField.setButtonLabel(NewWizardMessages.getString("EditVariableEntryDialog.filename.external.varbutton"));
        this.fFileNameField.setVariableButtonLabel(NewWizardMessages.getString("EditVariableEntryDialog.filename.variable.button"));
        this.fFileNameField.setText(this.fEditEntry.toString());
    }

    public IPath getPath() {
        return new Path(this.fFileNameField.getText());
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 3;
        int widthHint = this.convertWidthInCharsToPixels(50);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        this.fFileNameField.doFillIntoGrid(composite, 4);
        LayoutUtil.setHorizontalSpan((Control)this.fFileNameField.getLabelControl(null), 3);
        LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
        this.fFullPathResolvedLabel = new CLabel(composite, 16384);
        this.fFullPathResolvedLabel.setText(this.getResolvedLabelString(this.fFileNameField.getText(), true));
        this.fFullPathResolvedLabel.setLayoutData((Object)new GridData(256));
        DialogField.createEmptySpace(composite, 2);
        this.fFileNameField.postSetFocusOnDialogField(parent.getDisplay());
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.source_attachment_context");
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void attachmentChangeControlPressed(DialogField field) {
        IPath jarFilePath;
        if (field == this.fFileNameField && (jarFilePath = this.chooseExtJarFile()) != null) {
            this.fFileNameField.setText(jarFilePath.toString());
        }
    }

    private void attachmentDialogFieldChanged(DialogField field) {
        if (field == this.fFileNameField) {
            this.fNameStatus = this.updateFileNameStatus();
        }
        this.doStatusLineUpdate();
    }

    private IPath chooseExtJarFile() {
        Path currPath = new Path(this.fFileNameField.getText());
        IPath resolvedPath = this.getResolvedPath((IPath)currPath);
        File initialSelection = resolvedPath != null ? resolvedPath.toFile() : null;
        String currVariable = currPath.segment(0);
        JARFileSelectionDialog dialog = new JARFileSelectionDialog(this.getShell(), false, false);
        dialog.setTitle(NewWizardMessages.getString("EditVariableEntryDialog.extvardialog.title"));
        dialog.setMessage(NewWizardMessages.getString("EditVariableEntryDialog.extvardialog.description"));
        dialog.setInput(this.fFileVariablePath.toFile());
        dialog.setInitialSelection(initialSelection);
        if (dialog.open() == 0) {
            File result = (File)dialog.getResult()[0];
            IPath returnPath = new Path(result.getPath()).makeAbsolute();
            return this.modifyPath(returnPath, currVariable);
        }
        return null;
    }

    private IPath getResolvedPath(IPath path) {
        IPath varPath;
        String varName;
        if (path != null && (varName = path.segment(0)) != null && (varPath = JavaCore.getClasspathVariable((String)varName)) != null) {
            return varPath.append(path.removeFirstSegments(1));
        }
        return null;
    }

    private IPath modifyPath(IPath path, String varName) {
        if (varName == null || path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return new Path(varName);
        }
        IPath varPath = JavaCore.getClasspathVariable((String)varName);
        path = varPath != null ? (varPath.isPrefixOf(path) ? path.removeFirstSegments(varPath.segmentCount()) : new Path(path.lastSegment())) : new Path(path.lastSegment());
        return new Path(varName).append(path);
    }

    private IStatus updateFileNameStatus() {
        StatusInfo status = new StatusInfo();
        this.fFileVariablePath = null;
        String fileName = this.fFileNameField.getText();
        if (fileName.length() == 0) {
            return status;
        }
        if (!Path.EMPTY.isValidPath(fileName)) {
            status.setError(NewWizardMessages.getString("EditVariableEntryDialog.filename.error.notvalid"));
            return status;
        }
        Path filePath = new Path(fileName);
        if (filePath.getDevice() != null) {
            status.setError(NewWizardMessages.getString("EditVariableEntryDialog.filename.error.deviceinpath"));
            return status;
        }
        String varName = filePath.segment(0);
        if (varName == null) {
            status.setError(NewWizardMessages.getString("EditVariableEntryDialog.filename.error.notvalid"));
            return status;
        }
        this.fFileVariablePath = JavaCore.getClasspathVariable((String)varName);
        if (this.fFileVariablePath == null) {
            status.setError(NewWizardMessages.getString("EditVariableEntryDialog.filename.error.varnotexists"));
            return status;
        }
        IPath resolvedPath = this.fFileVariablePath.append(filePath.removeFirstSegments(1));
        if (resolvedPath.isEmpty()) {
            status.setWarning(NewWizardMessages.getString("EditVariableEntryDialog.filename.warning.varempty"));
            return status;
        }
        File file = resolvedPath.toFile();
        if (!file.isFile()) {
            String message = NewWizardMessages.getFormattedString("EditVariableEntryDialog.filename.error.filenotexists", resolvedPath.toOSString());
            status.setInfo(message);
            return status;
        }
        return status;
    }

    private String getResolvedLabelString(String path, boolean osPath) {
        IPath resolvedPath = this.getResolvedPath((IPath)new Path(path));
        if (resolvedPath != null) {
            if (osPath) {
                return resolvedPath.toOSString();
            }
            return resolvedPath.toString();
        }
        return "";
    }

    private boolean canBrowseFileName() {
        if (this.fFileVariablePath != null) {
            return this.fFileVariablePath.toFile().isDirectory();
        }
        return false;
    }

    private void doStatusLineUpdate() {
        IPath path;
        IStatus status;
        this.fFileNameField.enableButton(this.canBrowseFileName());
        if (this.fFullPathResolvedLabel != null) {
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString(this.fFileNameField.getText(), true));
        }
        if (!(status = this.fNameStatus).matches(4) && this.fExistingEntries.contains(path = this.getPath())) {
            String message = NewWizardMessages.getString("EditVariableEntryDialog.filename.error.alreadyexists");
            status = new StatusInfo(4, message);
        }
        this.updateStatus(status);
    }

    private class SourceAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        SourceAttachmentAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            EditVariableEntryDialog.this.attachmentChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            EditVariableEntryDialog.this.attachmentDialogFieldChanged(field);
        }
    }
}

