/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerDefaultPage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerDescriptor;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerSelectionPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ClasspathContainerWizard
extends Wizard {
    private ClasspathContainerDescriptor fPageDesc;
    private IClasspathEntry fEntryToEdit;
    private IClasspathEntry fNewEntry;
    private IClasspathContainerPage fContainerPage;
    private IJavaProject fCurrProject;
    private IClasspathEntry[] fCurrClasspath;
    private ClasspathContainerSelectionPage fSelectionWizardPage;

    public ClasspathContainerWizard(IClasspathEntry entryToEdit, IJavaProject currProject, IClasspathEntry[] currEntries) {
        this(entryToEdit, null, currProject, currEntries);
    }

    public ClasspathContainerWizard(ClasspathContainerDescriptor pageDesc, IJavaProject currProject, IClasspathEntry[] currEntries) {
        this(null, pageDesc, currProject, currEntries);
    }

    public ClasspathContainerWizard(ClasspathContainerDescriptor pageDesc) {
        this(null, pageDesc, null, null);
    }

    private ClasspathContainerWizard(IClasspathEntry entryToEdit, ClasspathContainerDescriptor pageDesc, IJavaProject currProject, IClasspathEntry[] currEntries) {
        this.fEntryToEdit = entryToEdit;
        this.fPageDesc = pageDesc;
        this.fNewEntry = null;
        this.fCurrProject = currProject;
        this.fCurrClasspath = currEntries;
    }

    public IClasspathEntry getNewEntry() {
        return this.fNewEntry;
    }

    public boolean performFinish() {
        if (this.fContainerPage != null && this.fContainerPage.finish()) {
            this.fNewEntry = this.fContainerPage.getSelection();
            return true;
        }
        return false;
    }

    public void addPages() {
        if (this.fPageDesc != null) {
            this.fContainerPage = this.getContainerPage(this.fPageDesc);
            this.addPage(this.fContainerPage);
        } else if (this.fEntryToEdit == null) {
            ClasspathContainerDescriptor[] containers = ClasspathContainerDescriptor.getDescriptors();
            this.fSelectionWizardPage = new ClasspathContainerSelectionPage(containers);
            this.addPage((IWizardPage)this.fSelectionWizardPage);
            this.fContainerPage = new ClasspathContainerDefaultPage();
            this.addPage(this.fContainerPage);
        } else {
            ClasspathContainerDescriptor[] containers = ClasspathContainerDescriptor.getDescriptors();
            ClasspathContainerDescriptor descriptor = this.findDescriptorPage(containers, this.fEntryToEdit);
            this.fContainerPage = this.getContainerPage(descriptor);
            this.addPage(this.fContainerPage);
        }
        super.addPages();
    }

    private IClasspathContainerPage getContainerPage(ClasspathContainerDescriptor pageDesc) {
        IClasspathContainerPage containerPage = null;
        if (pageDesc != null) {
            try {
                containerPage = pageDesc.createPage();
            }
            catch (CoreException e) {
                this.handlePageCreationFailed(e);
                containerPage = null;
            }
        }
        if (containerPage == null) {
            containerPage = new ClasspathContainerDefaultPage();
        }
        if (containerPage instanceof IClasspathContainerPageExtension) {
            ((IClasspathContainerPageExtension)((Object)containerPage)).initialize(this.fCurrProject, this.fCurrClasspath);
        }
        containerPage.setSelection(this.fEntryToEdit);
        containerPage.setWizard((IWizard)this);
        return containerPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fSelectionWizardPage) {
            ClasspathContainerDescriptor selected = this.fSelectionWizardPage.getSelected();
            this.fContainerPage = this.getContainerPage(selected);
            return this.fContainerPage;
        }
        return super.getNextPage(page);
    }

    private void handlePageCreationFailed(CoreException e) {
        String title = NewWizardMessages.getString("ClasspathContainerWizard.pagecreationerror.title");
        String message = NewWizardMessages.getString("ClasspathContainerWizard.pagecreationerror.message");
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    private ClasspathContainerDescriptor findDescriptorPage(ClasspathContainerDescriptor[] containers, IClasspathEntry entry) {
        int i = 0;
        while (i < containers.length) {
            if (containers[i].canEdit(entry)) {
                return containers[i];
            }
            ++i;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.fSelectionWizardPage != null && !this.fContainerPage.isPageComplete()) {
            return false;
        }
        if (this.fContainerPage != null) {
            return this.fContainerPage.isPageComplete();
        }
        return false;
    }
}

