/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.ui.JavaUI;

public class CPListElement {
    public static final String SOURCEATTACHMENT = "sourcepath";
    public static final String SOURCEATTACHMENTROOT = "rootpath";
    public static final String JAVADOC = "javadoc";
    public static final String OUTPUT = "output";
    public static final String EXCLUSION = "exclusion";
    private IJavaProject fProject;
    private int fEntryKind;
    private IPath fPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fIsMissing;
    private CPListElement fParentContainer;
    private IClasspathEntry fCachedEntry;
    private ArrayList fChildren;

    public CPListElement(IJavaProject project, int entryKind, IPath path, IResource res) {
        this.fProject = project;
        this.fEntryKind = entryKind;
        this.fPath = path;
        this.fChildren = new ArrayList();
        this.fResource = res;
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = null;
        switch (entryKind) {
            case 3: {
                this.createAttributeElement(OUTPUT, null);
                this.createAttributeElement(EXCLUSION, new Path[0]);
                break;
            }
            case 1: 
            case 4: {
                this.createAttributeElement(SOURCEATTACHMENT, null);
                this.createAttributeElement(JAVADOC, null);
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)this.fPath, (IJavaProject)this.fProject);
                    if (container == null) break;
                    IClasspathEntry[] entries = container.getClasspathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        CPListElement curr = CPListElement.createFromExisting(entries[i], this.fProject);
                        curr.setParentContainer(this);
                        this.fChildren.add(curr);
                        ++i;
                    }
                    break;
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    public IClasspathEntry getClasspathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newClasspathEntry();
        }
        return this.fCachedEntry;
    }

    private IClasspathEntry newClasspathEntry() {
        switch (this.fEntryKind) {
            case 3: {
                IPath outputLocation = (IPath)this.getAttribute(OUTPUT);
                IPath[] exclusionPattern = (IPath[])this.getAttribute(EXCLUSION);
                return JavaCore.newSourceEntry((IPath)this.fPath, (IPath[])exclusionPattern, (IPath)outputLocation);
            }
            case 1: {
                IPath attach = (IPath)this.getAttribute(SOURCEATTACHMENT);
                return JavaCore.newLibraryEntry((IPath)this.fPath, (IPath)attach, null, (boolean)this.isExported());
            }
            case 2: {
                return JavaCore.newProjectEntry((IPath)this.fPath, (boolean)this.isExported());
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)this.fPath, (boolean)this.isExported());
            }
            case 4: {
                IPath varAttach = (IPath)this.getAttribute(SOURCEATTACHMENT);
                return JavaCore.newVariableEntry((IPath)this.fPath, (IPath)varAttach, null, (boolean)this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public CPListElementAttribute setAttribute(String key, Object value) {
        CPListElementAttribute attribute = this.findAttributeElement(key);
        if (attribute == null) {
            return null;
        }
        attribute.setValue(value);
        this.attributeChanged(key);
        return attribute;
    }

    private CPListElementAttribute findAttributeElement(String key) {
        int i = 0;
        while (i < this.fChildren.size()) {
            CPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute && key.equals((elem = (CPListElementAttribute)curr).getKey())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public Object getAttribute(String key) {
        CPListElementAttribute attrib = this.findAttributeElement(key);
        if (attrib != null) {
            return attrib.getValue();
        }
        return null;
    }

    private void createAttributeElement(String key, Object value) {
        this.fChildren.add(new CPListElementAttribute(this, key, value));
    }

    public Object[] getChildren(boolean hideOutputFolder) {
        if (hideOutputFolder && this.fEntryKind == 3) {
            return new Object[]{this.findAttributeElement(EXCLUSION)};
        }
        return this.fChildren.toArray();
    }

    private void setParentContainer(CPListElement element) {
        this.fParentContainer = element;
    }

    public CPListElement getParentContainer() {
        return this.fParentContainer;
    }

    private void attributeChanged(String key) {
        this.fCachedEntry = null;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            CPListElement elem = (CPListElement)other;
            return elem.fEntryKind == this.fEntryKind && elem.fPath.equals((Object)this.fPath);
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind;
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public void setIsMissing(boolean isMissing) {
        this.fIsMissing = isMissing;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean isExported) {
        if (isExported != this.fIsExported) {
            this.fIsExported = isExported;
            this.attributeChanged(null);
        }
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public static CPListElement createFromExisting(IClasspathEntry curr, IJavaProject project) {
        IPath path = curr.getPath();
        IWorkspaceRoot root = project.getProject().getWorkspace().getRoot();
        IResource res = null;
        boolean isMissing = false;
        URL javaDocLocation = null;
        switch (curr.getEntryKind()) {
            case 5: {
                res = null;
                try {
                    isMissing = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)project) == null;
                }
                catch (JavaModelException javaModelException) {
                    isMissing = true;
                }
                break;
            }
            case 4: {
                IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
                res = null;
                isMissing = root.findMember(resolvedPath) == null && !resolvedPath.toFile().isFile();
                javaDocLocation = JavaUI.getLibraryJavadocLocation(resolvedPath);
                break;
            }
            case 1: {
                res = root.findMember(path);
                if (res == null) {
                    if (!ArchiveFileFilter.isArchivePath(path) && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    isMissing = !path.toFile().isFile();
                }
                javaDocLocation = JavaUI.getLibraryJavadocLocation(path);
                break;
            }
            case 3: {
                res = root.findMember(path);
                if (res != null) break;
                if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                isMissing = true;
                break;
            }
            case 2: {
                res = root.findMember(path);
                isMissing = res == null;
            }
        }
        CPListElement elem = new CPListElement(project, curr.getEntryKind(), path, res);
        elem.setExported(curr.isExported());
        elem.setAttribute(SOURCEATTACHMENT, curr.getSourceAttachmentPath());
        elem.setAttribute(JAVADOC, javaDocLocation);
        elem.setAttribute(OUTPUT, curr.getOutputLocation());
        elem.setAttribute(EXCLUSION, curr.getExclusionPatterns());
        if (project.exists()) {
            elem.setIsMissing(isMissing);
        }
        return elem;
    }
}

