/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class SuperInterfaceSelectionDialog
extends TypeSelectionDialog {
    private static final int ADD_ID = 1025;
    private ListDialogField fList;
    private List fOldContent;

    public SuperInterfaceSelectionDialog(Shell parent, IRunnableContext context, ListDialogField list, IJavaProject p) {
        super(parent, context, 6, SuperInterfaceSelectionDialog.createSearchScope(p));
        this.fList = list;
        this.fOldContent = this.fList.getElements();
        this.setStatusLineAboveButtons(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, NewWizardMessages.getString("SuperInterfaceSelectionDialog.addButton.label"), true);
        super.createButtonsForButtonBar(parent);
    }

    protected void cancelPressed() {
        this.fList.setElements(this.fOldContent);
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.addSelectedInterface();
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.addSelectedInterface();
        super.okPressed();
    }

    private void addSelectedInterface() {
        Object ref = this.getLowerSelectedElement();
        if (ref instanceof TypeInfo) {
            String qualifiedName = ((TypeInfo)ref).getFullyQualifiedName();
            this.fList.addElement(qualifiedName);
            String message = NewWizardMessages.getFormattedString("SuperInterfaceSelectionDialog.interfaceadded.info", qualifiedName);
            this.updateStatus(new StatusInfo(1, message));
        }
    }

    private static IJavaSearchScope createSearchScope(IJavaProject p) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{p});
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(1025);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.super_interface_selection_dialog_context");
    }
}

