/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewSnippetFileWizardPage
extends WizardNewFileCreationPage {
    private static final String fgDefaultExtension = ".jpage";

    public NewSnippetFileWizardPage(IStructuredSelection selection) {
        super("createScrapBookPage", selection);
        this.setTitle(NewWizardMessages.getString("NewSnippetFileWizardPage.title"));
    }

    public boolean finish() {
        String fileName = this.getFileName();
        if (fileName != null && !fileName.endsWith(fgDefaultExtension)) {
            this.setFileName(String.valueOf(fileName) + fgDefaultExtension);
        }
        boolean retValue = super.validatePage();
        final IFile file = this.createNewFile();
        if (retValue && file != null) {
            Shell shell = this.getShell();
            IWorkbenchPage page = JavaPlugin.getActivePage();
            if (shell == null || page == null) {
                return true;
            }
            final IWorkbenchPart focusPart = page.getActivePart();
            if (focusPart instanceof ISetSelectionTarget) {
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        StructuredSelection selection = new StructuredSelection((Object)file);
                        ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                    }
                });
            }
            try {
                page.openEditor(file);
                return true;
            }
            catch (PartInitException e) {
                ExceptionHandler.handle((CoreException)((Object)e), shell, NewWizardMessages.getString("NewSnippetFileWizardPage.open_error.message"), e.getMessage());
            }
        }
        return false;
    }

    protected boolean validatePage() {
        String fileName;
        boolean valid = super.validatePage();
        if (!valid) {
            return false;
        }
        IWorkspaceRoot workspaceRoot = JavaPlugin.getWorkspace().getRoot();
        IPath containerPath = this.getContainerFullPath();
        if (containerPath != null && containerPath.segmentCount() > 0) {
            IProject project = workspaceRoot.getProject(containerPath.segment(0));
            try {
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                    this.setErrorMessage(NewWizardMessages.getString("NewSnippetFileWizardPage.error.OnlyInJavaProject"));
                    return false;
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e.getStatus());
            }
        }
        if ((fileName = this.getFileName()) != null && !fileName.endsWith(fgDefaultExtension)) {
            fileName = String.valueOf(fileName) + fgDefaultExtension;
            IPath path = this.getContainerFullPath();
            if (path != null && workspaceRoot.exists(path.append(fileName))) {
                this.setErrorMessage(NewWizardMessages.getString("NewSnippetFileWizardPage.error.AlreadyExists"));
                return false;
            }
        }
        return true;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.new_snippet_wizard_page_context");
    }
}

