/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;

public class OpenTypeHierarchyUtil {
    private OpenTypeHierarchyUtil() {
    }

    public static TypeHierarchyViewPart open(IJavaElement element, IWorkbenchWindow window) {
        IJavaElement[] candidates = OpenTypeHierarchyUtil.getCandidates(element);
        if (candidates != null) {
            return OpenTypeHierarchyUtil.open(candidates, window);
        }
        return null;
    }

    public static TypeHierarchyViewPart open(IJavaElement[] candidates, IWorkbenchWindow window) {
        Assert.isTrue((candidates != null && candidates.length != 0 ? 1 : 0) != 0);
        IJavaElement input = null;
        if (candidates.length > 1) {
            String title = JavaUIMessages.getString("OpenTypeHierarchyUtil.selectionDialog.title");
            String message = JavaUIMessages.getString("OpenTypeHierarchyUtil.selectionDialog.message");
            input = OpenActionUtil.selectJavaElement(candidates, window.getShell(), title, message);
        } else {
            input = candidates[0];
        }
        if (input == null) {
            return null;
        }
        try {
            if ("perspective".equals(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.openTypeHierarchy"))) {
                return OpenTypeHierarchyUtil.openInPerspective(window, input);
            }
            return OpenTypeHierarchyUtil.openInViewPart(window, input);
        }
        catch (WorkbenchException e) {
            ExceptionHandler.handle((CoreException)((Object)e), window.getShell(), JavaUIMessages.getString("OpenTypeHierarchyUtil.error.open_perspective"), e.getMessage());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), window.getShell(), JavaUIMessages.getString("OpenTypeHierarchyUtil.error.open_editor"), e.getMessage());
        }
        return null;
    }

    private static TypeHierarchyViewPart openInViewPart(IWorkbenchWindow window, IJavaElement input) {
        IWorkbenchPage page = window.getActivePage();
        try {
            TypeHierarchyViewPart result = (TypeHierarchyViewPart)page.showView("org.eclipse.jdt.ui.TypeHierarchy");
            result.setInputElement(input);
            if (input instanceof IMember) {
                result.selectMember((IMember)input);
                OpenTypeHierarchyUtil.openEditor(input, false);
            }
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), JavaUIMessages.getString("OpenTypeHierarchyUtil.error.open_view"), e.getMessage());
            return null;
        }
    }

    private static TypeHierarchyViewPart openInPerspective(IWorkbenchWindow window, IJavaElement input) throws WorkbenchException, JavaModelException {
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        Object perspectiveInput = input;
        if (input instanceof IMember) {
            perspectiveInput = (input = JavaModelUtil.toOriginal((IMember)input)).getElementType() != 7 ? ((IMember)input).getDeclaringType() : input;
        }
        IWorkbenchPage page = workbench.showPerspective("org.eclipse.jdt.ui.JavaHierarchyPerspective", window, (IAdaptable)perspectiveInput);
        TypeHierarchyViewPart part = (TypeHierarchyViewPart)page.showView("org.eclipse.jdt.ui.TypeHierarchy");
        part.setInputElement((IJavaElement)perspectiveInput);
        if (input instanceof IMember) {
            OpenTypeHierarchyUtil.openEditor(input, false);
        }
        return part;
    }

    private static void openEditor(Object input, boolean activate) throws PartInitException, JavaModelException {
        IEditorPart part = EditorUtility.openInEditor(input, activate);
        if (input instanceof IJavaElement) {
            EditorUtility.revealInEditor(part, (IJavaElement)input);
        }
    }

    public static IJavaElement[] getCandidates(Object input) {
        if (!(input instanceof IJavaElement)) {
            return null;
        }
        try {
            Object elem = (IJavaElement)input;
            switch (elem.getElementType()) {
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return new IJavaElement[]{elem};
                }
                case 4: {
                    if (((IPackageFragment)elem).containsJavaResources()) {
                        return new IJavaElement[]{elem};
                    }
                    break;
                }
                case 11: {
                    return new IJavaElement[]{elem.getAncestor(4)};
                }
                case 13: {
                    IImportDeclaration decl = (IImportDeclaration)elem;
                    elem = decl.isOnDemand() ? JavaModelUtil.findTypeContainer(elem.getJavaProject(), Signature.getQualifier((String)elem.getElementName())) : elem.getJavaProject().findType(elem.getElementName());
                    if (elem == null) {
                        return null;
                    }
                    return new IJavaElement[]{elem};
                }
                case 6: {
                    return new IJavaElement[]{((IClassFile)input).getType()};
                }
                case 5: {
                    IType[] types;
                    ICompilationUnit cu = (ICompilationUnit)elem.getAncestor(5);
                    if (cu != null && (types = cu.getTypes()).length > 0) {
                        return types;
                    }
                    break;
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }
}

