/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public abstract class TypeHierarchyContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    protected TypeHierarchyLifeCycle fTypeHierarchy;
    protected IMember[] fMemberFilter;
    protected boolean fShowAllTypes;
    protected TreeViewer fViewer;

    public TypeHierarchyContentProvider(TypeHierarchyLifeCycle lifecycle) {
        this.fTypeHierarchy = lifecycle;
        this.fMemberFilter = null;
        this.fShowAllTypes = false;
    }

    public void setMemberFilter(IMember[] memberFilter) {
        this.fMemberFilter = memberFilter;
    }

    public IMember[] getMemberFilter() {
        return this.fMemberFilter;
    }

    public void showAllTypes(boolean show) {
        this.fShowAllTypes = show;
    }

    protected final ITypeHierarchy getHierarchy() {
        return this.fTypeHierarchy.getHierarchy();
    }

    public boolean providesWorkingCopies() {
        return this.fTypeHierarchy.isReconciled();
    }

    public Object[] getElements(Object parent) {
        IType input;
        ITypeHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null && (input = hierarchy.getType()) != null) {
            return new IType[]{input};
        }
        return NO_ELEMENTS;
    }

    protected abstract IType[] getTypesInHierarchy(IType var1);

    protected abstract IType getParentType(IType var1);

    public Object[] getChildren(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            Object[] childrenTypes = this.getTypesInHierarchy(type);
            if (this.fMemberFilter != null) {
                ArrayList children = new ArrayList();
                this.addFilteredMembers(type, children);
                this.addFilteredTypes((IType[])childrenTypes, children);
                return children.toArray();
            }
            return childrenTypes;
        }
        return NO_ELEMENTS;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            if (this.fMemberFilter != null) {
                try {
                    return this.hasFilteredChildren(type);
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            IType[] childrenTypes = this.getTypesInHierarchy(type);
            return childrenTypes.length > 0;
        }
        return false;
    }

    private void addFilteredMembers(IType origType, List children) {
        try {
            IType parent = this.providesWorkingCopies() ? (IType)JavaModelUtil.toWorkingCopy((IMember)origType) : origType;
            IMethod[] methods = parent.getMethods();
            int i = 0;
            while (i < this.fMemberFilter.length) {
                IMethod curr;
                IMethod meth;
                IMember member = this.fMemberFilter[i];
                if (parent.equals(member.getDeclaringType())) {
                    if (!children.contains(member)) {
                        children.add(member);
                    }
                } else if (member instanceof IMethod && (meth = JavaModelUtil.findMethod((curr = (IMethod)member).getElementName(), curr.getParameterTypes(), curr.isConstructor(), methods)) != null && !children.contains(meth)) {
                    children.add(meth);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private void addFilteredTypes(IType[] types, List children) {
        try {
            int i = 0;
            while (i < types.length) {
                if (this.hasFilteredChildren(types[i])) {
                    children.add(types[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private boolean hasFilteredChildren(IType origType) throws JavaModelException {
        if (this.fShowAllTypes) {
            return true;
        }
        IType type = this.providesWorkingCopies() ? (IType)JavaModelUtil.toWorkingCopy((IMember)origType) : origType;
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < this.fMemberFilter.length) {
            IMethod curr;
            IMethod meth;
            IMember member = this.fMemberFilter[i];
            if (type.equals(member.getDeclaringType())) {
                return true;
            }
            if (member instanceof IMethod && (meth = JavaModelUtil.findMethod((curr = (IMethod)member).getElementName(), curr.getParameterTypes(), curr.isConstructor(), methods)) != null) {
                return true;
            }
            ++i;
        }
        IType[] childrenTypes = this.getTypesInHierarchy(origType);
        int i2 = 0;
        while (i2 < childrenTypes.length) {
            if (this.hasFilteredChildren(childrenTypes[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void inputChanged(Viewer part, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(part instanceof TreeViewer));
        this.fViewer = (TreeViewer)part;
    }

    public void dispose() {
    }

    public Object getParent(Object element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            if (member.getElementType() == 7) {
                return this.getParentType((IType)member);
            }
            return member.getDeclaringType();
        }
        return null;
    }
}

