/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class SubTypeHierarchyViewer
extends TypeHierarchyViewer {
    public SubTypeHierarchyViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle, IWorkbenchPart part) {
        super(parent, (IContentProvider)new SubTypeHierarchyContentProvider(lifeCycle), lifeCycle, part);
    }

    public String getTitle() {
        if (this.isMethodFiltering()) {
            return TypeHierarchyMessages.getString("SubTypeHierarchyViewer.filtered.title");
        }
        return TypeHierarchyMessages.getString("SubTypeHierarchyViewer.title");
    }

    public void updateContent(boolean expand) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (expand) {
            int expandLevel = 2;
            if (this.isMethodFiltering()) {
                ++expandLevel;
            }
            this.expandToLevel(expandLevel);
        }
        this.getTree().setRedraw(true);
    }

    private static class SubTypeHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public SubTypeHierarchyContentProvider(TypeHierarchyLifeCycle lifeCycle) {
            super(lifeCycle);
        }

        protected final IType[] getTypesInHierarchy(IType type) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                return hierarchy.getSubtypes(type);
            }
            return new IType[0];
        }

        protected IType getParentType(IType type) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                return hierarchy.getSuperclass(type);
            }
            return null;
        }
    }
}

