/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.OverrideIndicatorLabelDecorator;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class HierarchyLabelProvider
extends AppearanceAwareLabelProvider {
    private boolean fShowDefiningType;
    private TypeHierarchyLifeCycle fHierarchy;

    public HierarchyLabelProvider(TypeHierarchyLifeCycle lifeCycle) {
        super(1090519049, 1);
        this.fHierarchy = lifeCycle;
        this.fShowDefiningType = false;
        this.addLabelDecorator(new HierarchyOverrideIndicatorLabelDecorator(lifeCycle));
    }

    public void setShowDefiningType(boolean showDefiningType) {
        this.fShowDefiningType = showDefiningType;
    }

    public boolean isShowDefiningType() {
        return this.fShowDefiningType;
    }

    private boolean isDifferentScope(IType type) {
        IJavaElement input = this.fHierarchy.getInputElement();
        if (input == null || input.getElementType() == 7) {
            return false;
        }
        IJavaElement parent = type.getAncestor(input.getElementType());
        return !(input.getElementType() == 4 ? parent == null || parent.getElementName().equals(input.getElementName()) : input.equals(parent));
    }

    private IType getDefiningType(Object element) throws JavaModelException {
        int kind = ((IJavaElement)element).getElementType();
        if (kind != 9 && kind != 8 && kind != 10) {
            return null;
        }
        IType declaringType = (IType)JavaModelUtil.toOriginal((IMember)((IMember)element).getDeclaringType());
        if (kind != 9) {
            return declaringType;
        }
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return declaringType;
        }
        IMethod method = (IMethod)element;
        int flags = method.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || method.isConstructor()) {
            return declaringType;
        }
        IMethod res = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, declaringType, method.getElementName(), method.getParameterTypes(), false);
        if (res == null || method.equals(res)) {
            return declaringType;
        }
        return res.getDeclaringType();
    }

    public String getText(Object element) {
        String text = super.getText(element);
        if (this.fShowDefiningType) {
            try {
                IType type = this.getDefiningType(element);
                if (type != null) {
                    StringBuffer buf = new StringBuffer(super.getText(type));
                    buf.append(JavaElementLabels.CONCAT_STRING);
                    buf.append(text);
                    return buf.toString();
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return text;
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof IType) {
            Object desc = this.getTypeImageDescriptor((IType)element);
            if (desc != null) {
                if (element.equals(this.fHierarchy.getInputElement())) {
                    desc = new FocusDescriptor((ImageDescriptor)desc);
                }
                result = JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
        } else {
            result = this.fImageLabelProvider.getImageLabel(element, this.evaluateImageFlags(element));
        }
        if (this.fLabelDecorators != null && result != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                result = decorator.decorateImage(result, element);
                ++i;
            }
        }
        return result;
    }

    private ImageDescriptor getTypeImageDescriptor(IType type) {
        boolean isInner;
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.BIG_SIZE);
        }
        IType originalType = (IType)JavaModelUtil.toOriginal((IMember)type);
        int flags = hierarchy.getCachedFlags(originalType);
        if (flags == -1) {
            return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.BIG_SIZE);
        }
        boolean isInterface = Flags.isInterface((int)flags);
        boolean bl = isInner = type.getDeclaringType() != null;
        ImageDescriptor desc = this.isDifferentScope(type) ? (isInterface ? JavaPluginImages.DESC_OBJS_INTERFACEALT : JavaPluginImages.DESC_OBJS_CLASSALT) : JavaElementImageProvider.getTypeImageDescriptor(isInterface, isInner, flags);
        int adornmentFlags = 0;
        if (Flags.isFinal((int)flags)) {
            adornmentFlags |= 2;
        }
        if (Flags.isAbstract((int)flags) && !isInterface) {
            adornmentFlags |= 1;
        }
        if (Flags.isStatic((int)flags)) {
            adornmentFlags |= 8;
        }
        return new JavaElementImageDescriptor(desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
    }

    private static class HierarchyOverrideIndicatorLabelDecorator
    extends OverrideIndicatorLabelDecorator {
        private TypeHierarchyLifeCycle fHierarchy;

        public HierarchyOverrideIndicatorLabelDecorator(TypeHierarchyLifeCycle lifeCycle) {
            super(null);
            this.fHierarchy = lifeCycle;
        }

        protected int getOverrideIndicators(IMethod method) throws JavaModelException {
            IType type = (IType)JavaModelUtil.toOriginal((IMember)method.getDeclaringType());
            ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
            if (hierarchy != null) {
                return this.findInHierarchy(type, hierarchy, method.getElementName(), method.getParameterTypes());
            }
            return 0;
        }
    }

    private static class FocusDescriptor
    extends CompositeImageDescriptor {
        private ImageDescriptor fBase;
        static /* synthetic */ Class class$0;

        public FocusDescriptor(ImageDescriptor base) {
            this.fBase = base;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.fBase.getImageData(), 0, 0);
            this.drawImage(JavaPluginImages.DESC_OVR_FOCUS.getImageData(), 0, 0);
        }

        protected Point getSize() {
            return JavaElementImageProvider.BIG_SIZE;
        }

        public int hashCode() {
            return this.fBase.hashCode();
        }

        public boolean equals(Object object) {
            if (object != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.internal.ui.typehierarchy.HierarchyLabelProvider$FocusDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(object.getClass()) && ((FocusDescriptor)((Object)object)).fBase.equals(this.fBase)) {
                    return true;
                }
            }
            return false;
        }
    }
}

