/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.template;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateBuffer;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jdt.internal.corext.template.TemplateMessages;
import org.eclipse.jdt.internal.corext.template.TemplatePosition;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionUI;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateProposal
implements IJavaCompletionProposal {
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final ITextViewer fViewer;
    private final Image fImage;
    private final IRegion fRegion;
    private int fRelevance;
    private IRegion fSelectedRegion;
    private String fDisplayString;

    public TemplateProposal(Template template, TemplateContext context, IRegion region, ITextViewer viewer, Image image) {
        Assert.isNotNull(template);
        Assert.isNotNull(context);
        Assert.isNotNull(region);
        Assert.isNotNull(viewer);
        this.fTemplate = template;
        this.fContext = context;
        this.fViewer = viewer;
        this.fImage = image;
        this.fRegion = region;
        this.fDisplayString = null;
        if (context instanceof JavaContext) {
            switch (((JavaContext)context).getCharacterBeforeStart()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.fRelevance = 90;
                    break;
                }
                default: {
                    this.fRelevance = 0;
                    break;
                }
            }
        } else {
            this.fRelevance = 90;
        }
    }

    public void apply(IDocument document) {
        try {
            Position position = new Position(this.fRegion.getOffset(), this.fRegion.getLength());
            String category = "__template_position_" + System.currentTimeMillis();
            DefaultPositionUpdater updater = new DefaultPositionUpdater(category);
            document.addPositionCategory(category);
            document.addPositionUpdater((IPositionUpdater)updater);
            document.addPosition(position);
            this.fContext.setReadOnly(false);
            TemplateBuffer templateBuffer = this.fContext.evaluate(this.fTemplate);
            if (templateBuffer == null) {
                this.fSelectedRegion = this.fRegion;
                return;
            }
            document.removePosition(position);
            document.removePositionUpdater((IPositionUpdater)updater);
            document.removePositionCategory(category);
            int start = position.getOffset();
            int end = position.getOffset() + position.getLength();
            String templateString = templateBuffer.getString();
            document.replace(start, end - start, templateString);
            LinkedPositionManager manager = new LinkedPositionManager(document);
            TemplatePosition[] variables = templateBuffer.getVariables();
            int i = 0;
            while (i != variables.length) {
                TemplatePosition variable = variables[i];
                if (!variable.isResolved()) {
                    int[] offsets = variable.getOffsets();
                    int length = variable.getLength();
                    int j = 0;
                    while (j != offsets.length) {
                        manager.addPosition(offsets[j] + start, length);
                        ++j;
                    }
                }
                ++i;
            }
            LinkedPositionUI editor = new LinkedPositionUI(this.fViewer, manager);
            editor.setFinalCaretOffset(this.getCaretOffset(templateBuffer) + start);
            editor.enter();
            this.fSelectedRegion = editor.getSelectedRegion();
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
        catch (BadPositionCategoryException e) {
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
        catch (CoreException e) {
            this.handleException(e);
            this.fSelectedRegion = this.fRegion;
        }
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplatePosition[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            if (variable.getName().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        try {
            this.fContext.setReadOnly(true);
            TemplateBuffer templateBuffer = this.fContext.evaluate(this.fTemplate);
            if (templateBuffer == null) {
                return null;
            }
            return TemplateProposal.textToHTML(templateBuffer.getString());
        }
        catch (CoreException e) {
            this.handleException(e);
            return null;
        }
    }

    public String getDisplayString() {
        if (this.fDisplayString == null) {
            this.fDisplayString = String.valueOf(this.fTemplate.getName()) + TemplateMessages.getString("TemplateProposal.delimiter") + this.fTemplate.getDescription();
        }
        return this.fDisplayString;
    }

    public void setDisplayString(String displayString) {
        this.fDisplayString = displayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private static String textToHTML(String string) {
        StringBuffer buffer = new StringBuffer(string.length());
        buffer.append("<pre>");
        int i = 0;
        while (i != string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '\t': {
                    buffer.append("    ");
                    break;
                }
                case '\n': {
                    buffer.append("<br>");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        buffer.append("</pre>");
        return buffer.toString();
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }

    private void handleException(CoreException e) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        ExceptionHandler.handle(e, shell, TemplateMessages.getString("TemplateEvaluator.error.title"), null);
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public Template getTemplate() {
        return this.fTemplate;
    }
}

