/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.template;

import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.Templates;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.jdt.internal.ui.text.template.TemplateProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;

public class TemplateEngine {
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";
    private ContextType fContextType;
    private ArrayList fProposals = new ArrayList();

    public TemplateEngine(ContextType contextType) {
        Assert.isNotNull(contextType);
        this.fContextType = contextType;
    }

    public void reset() {
        this.fProposals.clear();
    }

    public TemplateProposal[] getResults() {
        return this.fProposals.toArray(new TemplateProposal[this.fProposals.size()]);
    }

    public void complete(ITextViewer viewer, int completionPosition, ICompilationUnit compilationUnit) throws JavaModelException {
        IDocument document = viewer.getDocument();
        if (LinkedPositionManager.hasActiveManager(document)) {
            return;
        }
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        Point selection = viewer.getSelectedRange();
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        CompilationUnitContext context = ((CompilationUnitContextType)this.fContextType).createContext(document, completionPosition, selection.y, compilationUnit);
        context.setVariable("selection", selectedText);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = Templates.getInstance().getTemplates();
        if (selection.y == 0) {
            int i = 0;
            while (i != templates.length) {
                if (context.canEvaluate(templates[i])) {
                    this.fProposals.add(new TemplateProposal(templates[i], context, (IRegion)region, viewer, JavaPluginImages.get("org.eclipse.jdt.ui.template_obj.gif")));
                }
                ++i;
            }
        } else {
            if (context.getKey().length() == 0) {
                context.setForceEvaluation(true);
            }
            boolean multipleLinesSelected = this.areMultipleLinesSelected(viewer);
            int i = 0;
            while (i != templates.length) {
                Template template = templates[i];
                if (context.canEvaluate(template) && template.getContextTypeName().equals(context.getContextType().getName()) && (!multipleLinesSelected && template.getPattern().indexOf($_WORD_SELECTION) != -1 || multipleLinesSelected && template.getPattern().indexOf($_LINE_SELECTION) != -1)) {
                    this.fProposals.add(new TemplateProposal(templates[i], context, (IRegion)region, viewer, JavaPluginImages.get("org.eclipse.jdt.ui.template_obj.gif")));
                }
                ++i;
            }
        }
    }

    private boolean areMultipleLinesSelected(ITextViewer viewer) {
        if (viewer == null) {
            return false;
        }
        Point s = viewer.getSelectedRange();
        if (s.y == 0) {
            return false;
        }
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(s.x);
            int endLine = document.getLineOfOffset(s.x + s.y);
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || s.x == line.getOffset() && s.y == line.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

