/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.internal.ui.text.JavaCommentScanner;
import org.eclipse.jdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public final class JavaDocScanner
extends JavaCommentScanner {
    private static String[] fgKeywords = new String[]{"@author", "@deprecated", "@exception", "@param", "@return", "@see", "@serial", "@serialData", "@serialField", "@since", "@throws", "@version"};
    private static String[] fgTokenProperties = new String[]{"java_doc_keyword", "java_doc_tag", "java_doc_link", "java_doc_default", "java_comment_task_tag"};

    public JavaDocScanner(IColorManager manager, IPreferenceStore store, Preferences coreStore) {
        super(manager, store, coreStore, "java_doc_default", fgTokenProperties);
    }

    public IDocument getDocument() {
        return ((RuleBasedScanner)this).fDocument;
    }

    protected List createRules() {
        List list = super.createRules();
        Token token = this.getToken("java_doc_tag");
        list.add(new TagRule((IToken)token));
        WordRule wordRule = new WordRule((IWordDetector)new HTMLCommentDetector(), (IToken)token);
        wordRule.addWord("<!--", (IToken)token);
        wordRule.addWord("--!>", (IToken)token);
        list.add(wordRule);
        token = this.getToken("java_doc_link");
        list.add(new SingleLineRule("{@link", "}", (IToken)token));
        list.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        token = this.getToken("java_doc_default");
        wordRule = new WordRule((IWordDetector)new JavaDocKeywordDetector(), (IToken)token);
        token = this.getToken("java_doc_keyword");
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)token);
            ++i;
        }
        list.add(wordRule);
        return list;
    }

    static class JavaDocKeywordDetector
    implements IWordDetector {
        JavaDocKeywordDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@';
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }

    static class HTMLCommentDetector
    implements IWordDetector {
        HTMLCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '<' || c == '-';
        }

        public boolean isWordPart(char c) {
            return c == '-' || c == '!' || c == '>';
        }
    }

    class TagRule
    extends SingleLineRule {
        public TagRule(IToken token) {
            super("<", ">", token, '\u0000');
        }

        public TagRule(IToken token, char escapeCharacter) {
            super("<", ">", token, escapeCharacter);
        }

        private IToken checkForWhitespace(ICharacterScanner scanner) {
            try {
                char c = JavaDocScanner.this.getDocument().getChar(JavaDocScanner.this.getTokenOffset() + 1);
                if (!Character.isWhitespace(c)) {
                    return ((PatternRule)this).fToken;
                }
            }
            catch (BadLocationException badLocationException) {}
            return Token.UNDEFINED;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            IToken result = super.evaluate(scanner);
            if (result == ((PatternRule)this).fToken) {
                return this.checkForWhitespace(scanner);
            }
            return result;
        }
    }
}

