/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.CompletionRequestorAdapter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavadocCompletionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.FileEditorInput;

public class JavaDocCompletionEvaluator
implements IJavadocCompletionProcessor {
    protected static final String[] fgTagProposals = new String[]{"@author", "@deprecated", "@docRoot", "@exception", "@inheritdoc", "@link", "@linkplain", "@param", "@return", "@see", "@serial", "@serialData", "@serialField", "@since", "@throws", "@value", "@version"};
    protected static final String[] fgHTMLProposals = new String[]{"<code>", "</code>", "<br>", "<b>", "</b>", "<i>", "</i>", "<pre>", "</pre>"};
    private ICompilationUnit fCompilationUnit;
    private IDocument fDocument;
    private int fCurrentPos;
    private int fCurrentLength;
    private String fErrorMessage;
    private JavaElementLabelProvider fLabelProvider;
    private List fResult = new ArrayList();
    private boolean fRestrictToMatchingCase;

    private static boolean isWordPart(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '#' || ch == '.' || ch == '/';
    }

    private static int findCharBeforeWord(IDocument doc, int lineBeginPos, int pos) {
        int currPos = pos - 1;
        if (currPos > lineBeginPos) {
            try {
                while (currPos > lineBeginPos && JavaDocCompletionEvaluator.isWordPart(doc.getChar(currPos))) {
                    --currPos;
                }
                return currPos;
            }
            catch (BadLocationException badLocationException) {}
        }
        return pos;
    }

    private static int findLastWhitespace(IDocument doc, int lineBeginPos, int pos) {
        try {
            int currPos = pos - 1;
            while (currPos >= lineBeginPos && Character.isWhitespace(doc.getChar(currPos))) {
                --currPos;
            }
            return currPos + 1;
        }
        catch (BadLocationException badLocationException) {
            return pos;
        }
    }

    private static int findClosingCharacter(IDocument doc, int pos, int end, char endChar) throws BadLocationException {
        int curr = pos;
        while (curr < end && doc.getChar(curr) != endChar) {
            ++curr;
        }
        if (curr < end) {
            return curr + 1;
        }
        return pos;
    }

    private static int findReplaceEndPos(IDocument doc, String newText, String oldText, int pos) {
        if (oldText.length() == 0 || oldText.equals(newText)) {
            return pos;
        }
        try {
            IRegion lineInfo = doc.getLineInformationOfOffset(pos);
            int end = lineInfo.getOffset() + lineInfo.getLength();
            if (newText.endsWith(">")) {
                return JavaDocCompletionEvaluator.findClosingCharacter(doc, pos, end, '>');
            }
            char ch = '\u0000';
            int pos1 = pos;
            while (pos1 < end && Character.isJavaIdentifierPart(ch = doc.getChar(pos1))) {
                ++pos1;
            }
            if (pos1 < end && ch == '(' && newText.endsWith(")")) {
                return JavaDocCompletionEvaluator.findClosingCharacter(doc, pos1, end, ')');
            }
            return pos1;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return pos;
        }
    }

    public IJavaCompletionProposal[] computeCompletionProposals(ICompilationUnit cu, int offset, int length, int flags) {
        this.fCompilationUnit = cu;
        this.fCurrentPos = offset;
        this.fCurrentLength = length;
        this.fRestrictToMatchingCase = (flags & 1) != 0;
        FileEditorInput editorInput = new FileEditorInput((IFile)cu.getOriginalElement().getResource());
        this.fDocument = JavaUI.getDocumentProvider().getDocument((Object)editorInput);
        this.fLabelProvider = new JavaElementLabelProvider(2050);
        try {
            try {
                this.evalProposals();
                IJavaCompletionProposal[] iJavaCompletionProposalArray = this.fResult.toArray(new JavaCompletionProposal[this.fResult.size()]);
                Object var7_7 = null;
                this.fLabelProvider.dispose();
                this.fLabelProvider = null;
                this.fResult.clear();
                return iJavaCompletionProposalArray;
            }
            catch (JavaModelException e) {
                this.fErrorMessage = e.getLocalizedMessage();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
            this.fResult.clear();
            throw throwable;
        }
        Object var7_9 = null;
        this.fLabelProvider.dispose();
        this.fLabelProvider = null;
        this.fResult.clear();
        return null;
    }

    private void evalProposals() throws JavaModelException {
        try {
            String tag;
            int word2Begin;
            IRegion info = this.fDocument.getLineInformationOfOffset(this.fCurrentPos);
            int lineBeginPos = info.getOffset();
            int word1Begin = JavaDocCompletionEvaluator.findCharBeforeWord(this.fDocument, lineBeginPos, this.fCurrentPos);
            if (word1Begin == this.fCurrentPos) {
                return;
            }
            char firstChar = this.fDocument.getChar(word1Begin);
            if (firstChar == '@') {
                String prefix = this.fDocument.get(word1Begin, this.fCurrentPos - word1Begin);
                this.addProposals(prefix, fgTagProposals, "org.eclipse.jdt.ui.jdoc_tag_obj.gif");
                return;
            }
            if (firstChar == '<') {
                String prefix = this.fDocument.get(word1Begin, this.fCurrentPos - word1Begin);
                this.addProposals(prefix, fgHTMLProposals, "org.eclipse.jdt.ui.html_tag_obj.gif");
                return;
            }
            if (!Character.isWhitespace(firstChar)) {
                return;
            }
            String prefix = this.fDocument.get(word1Begin + 1, this.fCurrentPos - word1Begin - 1);
            int word2End = JavaDocCompletionEvaluator.findLastWhitespace(this.fDocument, lineBeginPos, word1Begin);
            if (word2End != lineBeginPos && this.fDocument.getChar(word2Begin = JavaDocCompletionEvaluator.findCharBeforeWord(this.fDocument, lineBeginPos, word2End)) == '@' && this.addArgumentProposals(tag = this.fDocument.get(word2Begin, word2End - word2Begin), prefix)) {
                return;
            }
            this.addAllTags(prefix);
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean prefixMatches(String prefix, String proposal) {
        if (this.fRestrictToMatchingCase) {
            return proposal.startsWith(prefix);
        }
        if (proposal.length() >= prefix.length()) {
            return prefix.equalsIgnoreCase(proposal.substring(0, prefix.length()));
        }
        return false;
    }

    private void addAllTags(String prefix) {
        String jdocPrefix = "@" + prefix;
        int i = 0;
        while (i < fgTagProposals.length) {
            String curr = fgTagProposals[i];
            if (this.prefixMatches(jdocPrefix, curr)) {
                this.fResult.add(this.createCompletion(curr, prefix, curr, JavaPluginImages.get("org.eclipse.jdt.ui.jdoc_tag_obj.gif"), null, 0));
            }
            ++i;
        }
        String htmlPrefix = "<" + prefix;
        int i2 = 0;
        while (i2 < fgHTMLProposals.length) {
            String curr = fgHTMLProposals[i2];
            if (this.prefixMatches(htmlPrefix, curr)) {
                this.fResult.add(this.createCompletion(curr, prefix, curr, JavaPluginImages.get("org.eclipse.jdt.ui.html_tag_obj.gif"), null, 0));
            }
            ++i2;
        }
    }

    private void addProposals(String prefix, String[] choices, String imageName) {
        int i = 0;
        while (i < choices.length) {
            String curr = choices[i];
            if (this.prefixMatches(prefix, curr)) {
                this.fResult.add(this.createCompletion(curr, prefix, curr, JavaPluginImages.get(imageName), null, 0));
            }
            ++i;
        }
    }

    private void addProposals(String prefix, IJavaElement[] choices) {
        int i = 0;
        while (i < choices.length) {
            IJavaElement elem = choices[i];
            String curr = this.getReplaceString(elem);
            if (this.prefixMatches(prefix, curr)) {
                ProposalInfo info = elem instanceof IMember ? new ProposalInfo((IMember)elem) : null;
                this.fResult.add(this.createCompletion(curr, prefix, this.fLabelProvider.getText(elem), this.fLabelProvider.getImage(elem), info, 0));
            }
            ++i;
        }
    }

    private String getReplaceString(IJavaElement elem) {
        if (elem instanceof IMethod) {
            IMethod meth = (IMethod)elem;
            StringBuffer buf = new StringBuffer();
            buf.append(meth.getElementName());
            buf.append('(');
            String[] types = meth.getParameterTypes();
            int last = types.length - 1;
            int i = 0;
            while (i <= last) {
                buf.append(Signature.toString((String)types[i]));
                if (i != last) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append(')');
            return buf.toString();
        }
        return elem.getElementName();
    }

    private boolean addArgumentProposals(String tag, String argument) throws JavaModelException {
        IJavaElement elem = this.fCompilationUnit.getElementAt(this.fCurrentPos);
        if ("@see".equals(tag) || "@link".equals(tag) || "@linkplain".equals(tag)) {
            if (elem instanceof IMember) {
                this.evalSeeTag((IMember)elem, argument);
                return true;
            }
        } else {
            if ("@param".equals(tag)) {
                if (elem instanceof IMethod) {
                    String[] names = ((IMethod)elem).getParameterNames();
                    this.addProposals(argument, names, "org.eclipse.jdt.ui.methdef_obj.gif");
                }
                return true;
            }
            if ("@throws".equals(tag) || "@exception".equals(tag)) {
                if (elem instanceof IMethod) {
                    String[] exceptions = ((IMethod)elem).getExceptionTypes();
                    int i = 0;
                    while (i < exceptions.length) {
                        String curr = Signature.toString((String)exceptions[i]);
                        if (this.prefixMatches(argument, curr)) {
                            this.fResult.add(this.createCompletion(curr, argument, curr, JavaPluginImages.get("org.eclipse.jdt.ui.class_obj.gif"), null, 100));
                        }
                        ++i;
                    }
                    this.evalTypeNameCompletions((IMember)((IMethod)elem), this.fCurrentPos - argument.length());
                }
                return true;
            }
            if ("@serialData".equals(tag)) {
                if (elem instanceof IField) {
                    String name = ((IField)elem).getElementName();
                    this.fResult.add(this.createCompletion(name, argument, name, this.fLabelProvider.getImage(elem), null, 0));
                }
                return true;
            }
        }
        return false;
    }

    private void evalSeeTag(IMember elem, String arg) throws JavaModelException {
        int wordStart = this.fCurrentPos - arg.length();
        int pidx = arg.indexOf(35);
        if (pidx == -1) {
            this.evalTypeNameCompletions(elem, wordStart);
        } else {
            IType parent = null;
            parent = pidx > 0 ? this.getTypeNameResolve(elem, wordStart, wordStart + pidx) : (IType)elem.getAncestor(7);
            if (parent != null) {
                int nidx = arg.indexOf(40, pidx);
                if (nidx == -1) {
                    nidx = arg.length();
                }
                String prefix = arg.substring(pidx + 1, nidx);
                this.addProposals(prefix, (IJavaElement[])parent.getMethods());
                this.addProposals(prefix, (IJavaElement[])parent.getFields());
            }
        }
    }

    private void evalTypeNameCompletions(IMember currElem, int wordStart) throws JavaModelException {
        block3: {
            ICompilationUnit preparedCU = this.createPreparedCU(currElem, wordStart, this.fCurrentPos);
            if (preparedCU == null) break block3;
            CompletionRequestorAdapter requestor = new CompletionRequestorAdapter(){

                public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int start, int end, int severity) {
                    JavaDocCompletionEvaluator.this.fResult.add(JavaDocCompletionEvaluator.this.createSeeTypeCompletion(true, start, end, completionName, className, packageName, severity));
                }

                public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int start, int end, int severity) {
                    JavaDocCompletionEvaluator.this.fResult.add(JavaDocCompletionEvaluator.this.createSeeTypeCompletion(false, start, end, completionName, interfaceName, packageName, severity));
                }

                public void acceptType(char[] packageName, char[] typeName, char[] completionName, int start, int end, int severity) {
                    JavaDocCompletionEvaluator.this.fResult.add(JavaDocCompletionEvaluator.this.createSeeTypeCompletion(true, start, end, completionName, typeName, packageName, severity));
                }
            };
            try {
                preparedCU.codeComplete(this.fCurrentPos, (ICompletionRequestor)requestor);
                if (currElem.getDeclaringType() == null && this.fCurrentPos > wordStart) {
                    IType type = (IType)currElem;
                    char[] name = type.getElementName().toCharArray();
                    this.fResult.add(this.createSeeTypeCompletion(type.isClass(), wordStart, this.fCurrentPos, name, name, JavaModelUtil.getTypeContainerName(type).toCharArray(), 50));
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                preparedCU.destroy();
                throw throwable;
            }
            Object var7_9 = null;
            preparedCU.destroy();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IType getTypeNameResolve(IMember elem, int wordStart, int wordEnd) throws JavaModelException {
        ICompilationUnit preparedCU;
        block3: {
            IType iType;
            block5: {
                IType iType2;
                block4: {
                    preparedCU = this.createPreparedCU(elem, wordStart, wordEnd);
                    if (preparedCU == null) return null;
                    try {
                        IJavaElement[] elements = preparedCU.codeSelect(wordStart, wordEnd - wordStart);
                        if (elements == null || elements.length != 1 || !(elements[0] instanceof IType)) break block3;
                        IType type = (IType)elements[0];
                        if (preparedCU.equals(type.getCompilationUnit())) {
                            IJavaElement[] res = elem.getCompilationUnit().findElements((IJavaElement)type);
                            if (res.length <= 0) break block3;
                            iType2 = (IType)res[0];
                            Object var8_10 = null;
                            break block4;
                        }
                        iType = type;
                        break block5;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        preparedCU.getBuffer().setContents(this.fCompilationUnit.getBuffer().getCharacters());
                        preparedCU.destroy();
                        throw throwable;
                    }
                }
                preparedCU.getBuffer().setContents(this.fCompilationUnit.getBuffer().getCharacters());
                preparedCU.destroy();
                return iType2;
            }
            Object var8_11 = null;
            preparedCU.getBuffer().setContents(this.fCompilationUnit.getBuffer().getCharacters());
            preparedCU.destroy();
            return iType;
        }
        Object var8_13 = null;
        preparedCU.getBuffer().setContents(this.fCompilationUnit.getBuffer().getCharacters());
        preparedCU.destroy();
        return null;
    }

    private ICompilationUnit createPreparedCU(IMember elem, int wordStart, int wordEnd) throws JavaModelException {
        ICompilationUnit cu;
        int startpos = elem.getSourceRange().getOffset();
        char[] content = (char[])this.fCompilationUnit.getBuffer().getCharacters().clone();
        if (elem.getDeclaringType() == null && wordStart + 6 < content.length) {
            content[startpos++] = 105;
            content[startpos++] = 109;
            content[startpos++] = 112;
            content[startpos++] = 111;
            content[startpos++] = 114;
            content[startpos++] = 116;
        }
        if (wordStart < content.length) {
            int i = startpos;
            while (i < wordStart) {
                content[i] = 32;
                ++i;
            }
        }
        if ((cu = this.fCompilationUnit).isWorkingCopy()) {
            cu = (ICompilationUnit)cu.getOriginalElement();
        }
        ICompilationUnit newCU = (ICompilationUnit)cu.getWorkingCopy();
        newCU.getBuffer().setContents(content);
        return newCU;
    }

    private JavaCompletionProposal createCompletion(String newText, String oldText, String labelText, Image image, ProposalInfo proposalInfo, int severity) {
        int offset = this.fCurrentPos - oldText.length();
        int length = this.fCurrentLength + oldText.length();
        if (this.fCurrentLength == 0) {
            length = JavaDocCompletionEvaluator.findReplaceEndPos(this.fDocument, newText, oldText, this.fCurrentPos) - offset;
        }
        JavaCompletionProposal proposal = new JavaCompletionProposal(newText, offset, length, image, labelText, severity);
        proposal.setProposalInfo(proposalInfo);
        proposal.setTriggerCharacters(new char[]{'#'});
        return proposal;
    }

    private JavaCompletionProposal createSeeTypeCompletion(boolean isClass, int start, int end, char[] completion, char[] typeName, char[] containerName, int severity) {
        ProposalInfo proposalInfo = new ProposalInfo(this.fCompilationUnit.getJavaProject(), containerName, typeName);
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(typeName);
        if (containerName != null) {
            nameBuffer.append(" - ");
            if (containerName.length > 0) {
                nameBuffer.append(containerName);
            } else {
                nameBuffer.append(JavaDocMessages.getString("CompletionEvaluator.default_package"));
            }
        }
        String imageKey = isClass ? "org.eclipse.jdt.ui.class_obj.gif" : "org.eclipse.jdt.ui.int_obj.gif";
        int compLen = completion.length;
        if (compLen > 0 && completion[compLen - 1] == ';') {
            --compLen;
        }
        JavaCompletionProposal proposal = new JavaCompletionProposal(new String(completion, 0, compLen), start, end - start, JavaPluginImages.get(imageKey), nameBuffer.toString(), severity);
        proposal.setProposalInfo(proposalInfo);
        proposal.setTriggerCharacters(new char[]{'#'});
        return proposal;
    }

    public IContextInformation[] computeContextInformation(ICompilationUnit cu, int offset) {
        this.fErrorMessage = null;
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }
}

