/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.io.IOException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.JavaCodeReader;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class JavaSourceHover
extends AbstractJavaEditorTextHover {
    private final int LABEL_FLAGS = 39136439;

    protected String getHoverInfo(IJavaElement[] result) {
        int nResults = result.length;
        StringBuffer buffer = new StringBuffer();
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList(buffer);
                IJavaElement curr = result[i];
                if (curr instanceof IMember) {
                    HTMLPrinter.addBullet(buffer, this.getInfoText((IMember)curr));
                }
                HTMLPrinter.endBulletList(buffer);
                ++i;
            }
        } else {
            IJavaElement curr = result[0];
            if (curr instanceof IMember && curr instanceof ISourceReference) {
                HTMLPrinter.addSmallHeader(buffer, this.getInfoText((IMember)curr));
                try {
                    String source = ((ISourceReference)curr).getSource();
                    source = this.removeLeadingComments(source);
                    HTMLPrinter.addParagraph(buffer, "<pre>");
                    HTMLPrinter.addParagraph(buffer, source);
                    HTMLPrinter.addParagraph(buffer, "</pre>");
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0);
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(IMember member) {
        return JavaElementLabels.getElementLabel((IJavaElement)member, 39136439);
    }

    private String removeLeadingComments(String source) {
        int i;
        JavaCodeReader reader = new JavaCodeReader();
        Document document = new Document(source);
        try {
            try {
                reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                int c = reader.read();
                while (c != -1 && (c == 13 || c == 10)) {
                    c = reader.read();
                }
                i = reader.getOffset();
                reader.close();
            }
            catch (IOException iOException) {
                i = 0;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                JavaPlugin.log(ex);
            }
            throw throwable;
        }
        Object var6_8 = null;
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException ex) {
            JavaPlugin.log(ex);
        }
        if (i < 0) {
            return source;
        }
        return source.substring(i);
    }
}

