/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;

public class JavaProblemHover
extends AbstractJavaEditorTextHover {
    private String formatMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.getEditor() == null) {
            return null;
        }
        CompilationUnitDocumentProvider provider = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel(this.getEditor().getEditorInput());
        if (model != null) {
            JavaAnnotationIterator e = new JavaAnnotationIterator(model, true);
            while (e.hasNext()) {
                String msg;
                Annotation a = (Annotation)e.next();
                Position p = model.getPosition(a);
                if (!p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = ((IJavaAnnotation)a).getMessage()) == null || msg.trim().length() <= 0) continue;
                return this.formatMessage(msg);
            }
        }
        return null;
    }

    public void setEditor(IEditorPart editor) {
        if (editor instanceof CompilationUnitEditor) {
            super.setEditor(editor);
        } else {
            super.setEditor(null);
        }
    }

    static boolean isJavaProblemHover(String id) {
        return PreferenceConstants.ID_PROBLEM_HOVER.equals(id);
    }
}

