/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class JavaEditorTextHoverProxy
extends AbstractJavaEditorTextHover {
    private JavaEditorTextHoverDescriptor fHoverDescriptor;
    private IJavaEditorTextHover fHover;

    public JavaEditorTextHoverProxy(JavaEditorTextHoverDescriptor descriptor, IEditorPart editor) {
        this.fHoverDescriptor = descriptor;
        this.setEditor(editor);
    }

    public void setEditor(IEditorPart editor) {
        super.setEditor(editor);
        if (this.fHover != null) {
            this.fHover.setEditor(this.getEditor());
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (!this.isEnabled() || this.fHoverDescriptor == null) {
            return null;
        }
        if (this.isCreated() || this.createHover()) {
            return this.fHover.getHoverRegion(textViewer, offset);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (!this.isEnabled() || this.fHoverDescriptor == null) {
            return null;
        }
        if (this.isCreated() || this.createHover()) {
            return this.fHover.getHoverInfo(textViewer, hoverRegion);
        }
        return null;
    }

    private boolean isCreated() {
        return this.fHover != null;
    }

    private boolean createHover() {
        this.fHover = this.fHoverDescriptor.createTextHover();
        if (this.fHover != null) {
            this.fHover.setEditor(this.getEditor());
        }
        return this.isCreated();
    }
}

