/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractJavaEditorTextHover
implements IJavaEditorTextHover {
    private IEditorPart fEditor;

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            if (input instanceof IClassFileEditorInput) {
                IClassFileEditorInput cfeInput = (IClassFileEditorInput)input;
                return cfeInput.getClassFile();
            }
            IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            return manager.getWorkingCopy(input);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        ICodeAssist resolve = this.getCodeAssist();
        if (resolve != null) {
            try {
                IJavaElement[] result = null;
                ICodeAssist iCodeAssist = resolve;
                synchronized (iCodeAssist) {
                    result = resolve.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
                }
                if (result == null) {
                    return null;
                }
                int nResults = result.length;
                if (nResults == 0) {
                    return null;
                }
                return this.getHoverInfo(result);
            }
            catch (JavaModelException x) {
                JavaPlugin.log(x.getStatus());
            }
        }
        return null;
    }

    protected String getHoverInfo(IJavaElement[] javaElements) {
        return null;
    }
}

